/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.catalog;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.ZooEventifyCenterFactory;
import kd.bos.instance.Cluster;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.catalog.LocalServiceCatalog;
import kd.bos.mservice.catalog.ServiceCatalog;
import kd.bos.mservice.catalog.ServiceCatalogCenter;
import kd.bos.mservice.catalog.view.DefinedMMethodInfo;
import kd.bos.mservice.catalog.view.DefinedMServiceInfo;
import kd.bos.mservice.catalog.view.MParamterInfo;
import kd.bos.mservice.catalog.view.MServiceInfo;
import kd.bos.mservice.catalog.view.ServiceFactoryMMethodInfo;
import kd.bos.mservice.catalog.view.ServiceFactoryMServiceInfo;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.mservice.spi.define.MServiceParameterParser;
import kd.bos.mservice.util.JSONUtils;
import kd.bos.util.SafeLogUtils;
import kd.bos.util.StringUtils;

public class RemoteServiceCatalog
extends LocalServiceCatalog
implements ServiceCatalogCenter {
    private static final Log LOG = LogFactory.getLog(RemoteServiceCatalog.class);
    private static final String SERVICE_CATALOG = "/runtime/servicecatalog";
    private static final String SERVICE_VIEW_CATALOG = "/runtime/serviceviewcatalog";
    private static final String SERVICE_CATALOG_SEPARATOR = "@@";
    private static final RemoteServiceCatalog instance = new RemoteServiceCatalog();
    private static final Map<String, MServiceDefineMeta> interfaceMServiceDefineMap = new ConcurrentHashMap<String, MServiceDefineMeta>(8);

    protected static ServiceCatalog getInstance() {
        return instance;
    }

    protected static ServiceCatalogCenter getInstanceCenter() {
        return instance;
    }

    @Override
    public Map<String, MServiceDefineMeta> getServiceFromCatalogCenter() {
        HashMap<String, MServiceDefineMeta> mServiceDefineMetaMap = new HashMap<String, MServiceDefineMeta>(8);
        String region = this.getRegionKey();
        ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
        String serviceCatalogPath = Instance.getClusterName() + SERVICE_CATALOG;
        Map childMap = messageCenter.getChildren(region, serviceCatalogPath);
        for (Map.Entry tempEntry : childMap.entrySet()) {
            String serviceName_ = (String)tempEntry.getKey();
            String jsonValue = (String)tempEntry.getValue();
            try {
                if (!StringUtils.isNotEmpty((String)jsonValue) || serviceName_.contains(SERVICE_CATALOG_SEPARATOR)) continue;
                MServiceDefineMeta mServiceDefineMeta = (MServiceDefineMeta)JSONUtils.cast((String)jsonValue, (boolean)true, MServiceDefineMeta.class, (Class[])new Class[0]);
                mServiceDefineMetaMap.put(mServiceDefineMeta.getServiceInterface(), mServiceDefineMeta);
            }
            catch (Exception e) {
                LOG.error("RemoteServiceCatalog getServiceFromCatalogCenter cast json error", (Throwable)e);
            }
        }
        return mServiceDefineMetaMap;
    }

    @Override
    public MServiceDefineMeta getMServiceDefineMeta(String interfaceName) {
        return interfaceMServiceDefineMap.computeIfAbsent(interfaceName, v -> {
            String region = this.getRegionKey();
            ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
            String serviceCatalogPath = Instance.getClusterName() + SERVICE_CATALOG;
            Map childMap = messageCenter.getChildren(region, serviceCatalogPath);
            for (Map.Entry tempEntry : childMap.entrySet()) {
                String serviceName_ = (String)tempEntry.getKey();
                String jsonValue = (String)tempEntry.getValue();
                try {
                    MServiceDefineMeta mServiceDefineMeta;
                    if (!StringUtils.isNotEmpty((String)jsonValue) || serviceName_.contains(SERVICE_CATALOG_SEPARATOR) || !(mServiceDefineMeta = (MServiceDefineMeta)JSONUtils.cast((String)jsonValue, (boolean)true, MServiceDefineMeta.class, (Class[])new Class[0])).getServiceInterface().equals(interfaceName)) continue;
                    return mServiceDefineMeta;
                }
                catch (Exception e) {
                    LOG.error("RemoteServiceCatalog getMServiceDefineMeta cast json error", (Throwable)e);
                }
            }
            return null;
        });
    }

    @Override
    public void regist(String type, Map<String, MServiceDefineMeta> serviceDefineMap) {
        if (!(serviceDefineMap != null && serviceDefineMap.size() != 0 || type.equals("servicefactory"))) {
            return;
        }
        Map<String, MServiceInfo> serviceInfoMap = this.transformToMserviceInfo(type, serviceDefineMap);
        super.regist(type, serviceDefineMap, serviceInfoMap);
        this.remoteRegist(type, serviceDefineMap, serviceInfoMap);
    }

    private Map<String, MServiceInfo> transformToMserviceInfo(String type, Map<String, MServiceDefineMeta> mserviceDefineMap) {
        if (type.equals("servicefactory")) {
            return this.transformByServiceFactory(mserviceDefineMap);
        }
        return this.transformByDefined(mserviceDefineMap);
    }

    private Map<String, MServiceInfo> transformByDefined(Map<String, MServiceDefineMeta> mserviceMeta) {
        ConcurrentHashMap<String, MServiceInfo> serviceInfoMap = new ConcurrentHashMap<String, MServiceInfo>(mserviceMeta.size());
        mserviceMeta.forEach((serviceName, serviceDefine) -> {
            DefinedMServiceInfo serviceInfo = new DefinedMServiceInfo();
            serviceInfo.setServiceName((String)serviceName);
            serviceInfo.setCloud("");
            serviceInfo.setAppId(String.join((CharSequence)",", serviceDefine.getAppIds()));
            serviceInfo.setPkg(serviceDefine.getPkg());
            serviceInfo.setDesc(serviceDefine.getServiceDesc());
            List methodDefineList = serviceDefine.getMethods();
            for (MServiceDefineMeta.MethodDefine tempMethodDefine : methodDefineList) {
                DefinedMMethodInfo methodInfo = new DefinedMMethodInfo();
                methodInfo.setMethodName(tempMethodDefine.getServiceMethodName());
                methodInfo.setReturnType(tempMethodDefine.getServiceMethodReturnObjectType());
                methodInfo.setParamModel("");
                methodInfo.setReturnValModel("");
                methodInfo.setDesc(tempMethodDefine.getServiceMethodDesc());
                serviceInfo.addMethod(methodInfo);
                List paramDefineList = tempMethodDefine.getServiceMethodParams();
                for (MServiceDefineMeta.ParamDefine tempParamDefine : paramDefineList) {
                    MParamterInfo paramterInfo = new MParamterInfo();
                    paramterInfo.setName(tempParamDefine.getName());
                    paramterInfo.setType(tempParamDefine.getTypeStr());
                    paramterInfo.setDesc(tempParamDefine.getDescribe());
                    methodInfo.addParameter(paramterInfo);
                }
            }
            serviceInfoMap.putIfAbsent((String)serviceName, serviceInfo);
        });
        return serviceInfoMap;
    }

    private Map<String, MServiceInfo> transformByServiceFactory(Map<String, MServiceDefineMeta> mserviceMeta) {
        ConcurrentHashMap<String, MServiceInfo> serviceInfoMap = new ConcurrentHashMap<String, MServiceInfo>(mserviceMeta.size());
        String bosServiceFactoryPackage = "kd.bos.service";
        String bosServiceFactoryClassName = bosServiceFactoryPackage + ".ServiceFactory";
        try {
            this.doTransformServiceFactory(serviceInfoMap, "bos", "bos", bosServiceFactoryPackage, bosServiceFactoryClassName);
        }
        catch (Exception ex) {
            throw new RuntimeException("transform " + bosServiceFactoryClassName + " error.", ex);
        }
        Map cloudAppMap = Cluster.getCloudAppidMapping();
        for (Map.Entry entry : cloudAppMap.entrySet()) {
            String appId = (String)entry.getKey();
            String cloud = ((String)entry.getValue()).toLowerCase();
            String packageName = "kd." + cloud.toLowerCase() + "." + appId.toLowerCase() + ".servicehelper";
            String className = packageName + ".ServiceFactory";
            this.doTransformServiceFactory(serviceInfoMap, cloud, appId, packageName, className);
        }
        return serviceInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransformServiceFactory(Map<String, MServiceInfo> serviceInfoMap, String cloud, String appId, String packageName, String className) {
        HashMap<String, String> copyServiceMap;
        Map serviceMap;
        try {
            Map tempServiceMap;
            Class<?> serviceFactoryClass = Class.forName(className, false, this.getClass().getClassLoader());
            Field serviceMapFiled = serviceFactoryClass.getDeclaredField("serviceMap");
            serviceMapFiled.setAccessible(true);
            serviceMap = tempServiceMap = (Map)serviceMapFiled.get(null);
        }
        catch (Error | Exception e) {
            return;
        }
        if (serviceMap == null || serviceMap.size() == 0) {
            return;
        }
        Map map = serviceMap;
        synchronized (map) {
            copyServiceMap = new HashMap<String, String>(serviceMap);
        }
        copyServiceMap.forEach((serviceName, serviceImplClass) -> {
            if (serviceInfoMap.containsKey(serviceName)) {
                return;
            }
            Class<?> mserviceDefineClass = null;
            try {
                mserviceDefineClass = Class.forName(serviceImplClass, false, this.getClass().getClassLoader());
                ServiceFactoryMServiceInfo serviceInfo = new ServiceFactoryMServiceInfo();
                serviceInfo.setServiceName((String)serviceName);
                serviceInfo.setCloud(cloud);
                serviceInfo.setAppId(appId);
                serviceInfo.setPkg(packageName);
                serviceInfo.setDesc("");
                Method[] methods = mserviceDefineClass.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    if (!Modifier.isPublic(methods[i].getModifiers())) continue;
                    Method method = methods[i];
                    ServiceFactoryMMethodInfo methodInfo = new ServiceFactoryMMethodInfo();
                    methodInfo.setMethodName(method.getName());
                    methodInfo.setReturnType(method.getGenericReturnType().getTypeName());
                    methodInfo.setParamModel("");
                    methodInfo.setReturnValModel("");
                    methodInfo.setDesc("");
                    serviceInfo.addMethod(methodInfo);
                    Parameter[] parameterArray = method.getParameters();
                    String[] parameterNames = MServiceParameterParser.getParameterNames((Method)methods[i]);
                    if (parameterArray == null || parameterArray.length <= 0) continue;
                    for (int j = 0; j < parameterArray.length; ++j) {
                        MParamterInfo paramterInfo = new MParamterInfo();
                        paramterInfo.setName(parameterNames[j]);
                        paramterInfo.setType(parameterArray[j].getParameterizedType().getTypeName());
                        paramterInfo.setDesc("");
                        methodInfo.addParameter(paramterInfo);
                    }
                }
                serviceInfoMap.putIfAbsent((String)serviceName, serviceInfo);
            }
            catch (ClassNotFoundException | NoClassDefFoundError serviceInfo) {
            }
            catch (Error | Exception e) {
                LOG.error("doTransformServiceFactory " + className + " error.", e);
            }
        });
    }

    private void remoteRegist(String type, Map<String, MServiceDefineMeta> serviceDefineMap, Map<String, MServiceInfo> serviceInfoMap) {
        this.registMServiceDefine(type, serviceDefineMap, SERVICE_CATALOG);
        if (!type.equals("servicefactory")) {
            // empty if block
        }
    }

    private void registMServiceDefine(String type, Map<String, MServiceDefineMeta> serviceDefineMap, String path) {
        try {
            String region = this.getRegionKey();
            String appIdPath = Instance.getClusterName() + path;
            serviceDefineMap.forEach((k, define) -> {
                String jsonValue = null;
                try {
                    jsonValue = JSONUtils.toString((Object)define, (boolean)true);
                }
                catch (IOException e) {
                    SafeLogUtils.error(this.getClass(), (String)"", (Throwable)e);
                    return;
                }
                ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
                messageCenter.setNodeWithPersistent(region, appIdPath, define.getServiceName(), jsonValue);
                String nodePath = appIdPath + "/" + define.getServiceName();
                messageCenter.setNode(region, nodePath, Instance.getInstanceId(), "");
            });
        }
        catch (Exception e) {
            LOG.error("RemoteServiceCatalog remoteRegist error", (Throwable)e);
        }
    }

    private void registMServiceInfo(String type, Map<String, MServiceInfo> serviceInfoMap, String path) {
        try {
            String region = this.getRegionKey();
            String appIdPath = Instance.getClusterName() + path;
            serviceInfoMap.forEach((k, info) -> {
                String jsonValue = null;
                try {
                    jsonValue = JSONUtils.toString((Object)info, (boolean)true);
                }
                catch (IOException e) {
                    SafeLogUtils.error(this.getClass(), (String)"", (Throwable)e);
                    return;
                }
                ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
                String nodeName = info.getServiceName() + SERVICE_CATALOG_SEPARATOR + info.getPkg();
                messageCenter.setNodeWithPersistent(region, appIdPath, nodeName, jsonValue);
                String nodePath = appIdPath + "/" + nodeName;
                messageCenter.setNode(region, nodePath, Instance.getInstanceId(), "");
            });
        }
        catch (Exception e) {
            LOG.error("RemoteServiceCatalog remoteRegist error", (Throwable)e);
        }
    }

    @Override
    public String getRegionKey() {
        return "configUrl";
    }
}

