/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.catalog.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.ZooEventifyCenterFactory;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.catalog.ServiceCatalogFactory;
import kd.bos.mservice.catalog.view.CatalogNode;
import kd.bos.mservice.catalog.view.DefinedMServiceInfo;
import kd.bos.mservice.catalog.view.MServiceInfo;
import kd.bos.mservice.catalog.view.ServiceFactoryMServiceInfo;
import kd.bos.mservice.util.JSONUtils;

public class ServiceCatalogManager {
    private static final Log LOG = LogFactory.getLog(ServiceCatalogManager.class);

    public static CatalogNode getAllCatalog() {
        CatalogNode root = new CatalogNode("root");
        List<String> viewCatalogList = ServiceCatalogManager.getViewCatalogChildren();
        for (String tempPath : viewCatalogList) {
            String[] pathArray = tempPath.split("@@");
            root.addPackage(pathArray[pathArray.length - 1]);
        }
        return root;
    }

    public static CatalogNode getLocalAllCatalog() {
        CatalogNode root = new CatalogNode("root");
        Map<String, MServiceInfo> serviceInfoMap = ServiceCatalogFactory.getCatalog().getAllServiceInfo();
        for (Map.Entry<String, MServiceInfo> tempEntry : serviceInfoMap.entrySet()) {
            MServiceInfo tempMServiceInfo = tempEntry.getValue();
            root.addPackage(tempMServiceInfo.getPkg());
        }
        return root;
    }

    public static List<MServiceInfo> getServiceByPackage(String pkg) {
        ArrayList<MServiceInfo> serviceInfoList = new ArrayList<MServiceInfo>(10);
        String region = ServiceCatalogFactory.getCatalogCenter().getRegionKey();
        String parentPath = Instance.getClusterName() + "/runtime/serviceviewcatalog";
        ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
        List childNameList = messageCenter.getChildrenNames(region, parentPath);
        for (String tempChildName : childNameList) {
            if (!tempChildName.contains(pkg)) continue;
            String jsonValue = messageCenter.getNodeValue(region, parentPath, tempChildName);
            try {
                boolean isFromServiceFactory = Boolean.parseBoolean(((Map)JSONUtils.cast((String)jsonValue, Map.class)).get("fromServiceFactory").toString());
                MServiceInfo mServiceInfo = isFromServiceFactory ? (MServiceInfo)JSONUtils.cast((String)jsonValue, ServiceFactoryMServiceInfo.class) : (MServiceInfo)JSONUtils.cast((String)jsonValue, DefinedMServiceInfo.class);
                serviceInfoList.add(mServiceInfo);
            }
            catch (Exception e) {
                LOG.error("SeviceCatalogManager getServiceByPackage error,package=" + pkg, (Throwable)e);
            }
        }
        return serviceInfoList;
    }

    private static List<String> getViewCatalogChildren() {
        String region = ServiceCatalogFactory.getCatalogCenter().getRegionKey();
        String parentPath = Instance.getClusterName() + "/runtime/serviceviewcatalog";
        ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
        return messageCenter.getChildrenNames(region, parentPath);
    }
}

