/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.define.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.mservice.annotation.KService;
import kd.bos.mservice.annotation.KServiceMethod;
import kd.bos.mservice.annotation.KServiceParam;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.mservice.spi.define.MServiceParameterParser;

public class AnnotationScan {
    public static Map<String, MServiceDefineMeta> scan(Set<String> serviceNames) {
        HashMap<String, MServiceDefineMeta> serviceDefineMap = new HashMap<String, MServiceDefineMeta>();
        serviceNames.forEach(mserviceDefineClassStr -> {
            String[] transprotocalTypes;
            String[] dataCodecTypes;
            Class<?> mserviceDefineClass;
            try {
                mserviceDefineClass = Class.forName(mserviceDefineClassStr, false, AnnotationScan.class.getClassLoader());
            }
            catch (Exception e) {
                return;
            }
            KService kservice = mserviceDefineClass.getAnnotation(KService.class);
            String group = kservice.group();
            String name = kservice.name();
            String[] appIds = kservice.appIds();
            MServiceDefineMeta mdm = new MServiceDefineMeta();
            mdm.setServiceGroupAndName(group, name);
            mdm.setServiceImplClass(mserviceDefineClass.getName());
            mdm.setRegisterOrginalInteface(false);
            Class<?>[] serviceInterface = mserviceDefineClass.getInterfaces();
            mdm.setServiceInterface(serviceInterface.length > 0 ? serviceInterface[0].getName() : mserviceDefineClass.getName());
            mdm.setAppIds(appIds);
            mdm.setServiceDesc(kservice.description());
            for (String codecType : dataCodecTypes = kservice.dataCodec()) {
                mdm.addDataCodecs(codecType);
            }
            for (String transprotocalType : transprotocalTypes = kservice.transprotocalType()) {
                mdm.addTransProtocolTypes(transprotocalType);
            }
            serviceDefineMap.put(mdm.getServiceName(), mdm);
            Method[] methods = mserviceDefineClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].isAnnotationPresent(KServiceMethod.class)) continue;
                methods[i].getAnnotatedReturnType();
                KServiceMethod kserviceMethod = methods[i].getAnnotation(KServiceMethod.class);
                MServiceDefineMeta.MethodDefine mDefine = new MServiceDefineMeta.MethodDefine();
                mdm.addMethod(mDefine);
                mDefine.setServiceMethodName(kserviceMethod.name());
                mDefine.setServiceMethodPath("/" + name + "/" + mDefine.getServiceMethodName());
                mDefine.setServiceMethodDesc(kserviceMethod.description());
                mDefine.setServiceMethodReturnObjectType(methods[i].getGenericReturnType().getTypeName());
                mDefine.setServiceMethodReturnParamDefine(MServiceParameterParser.parseParam((Type)methods[i].getGenericReturnType()));
                Parameter[] params = methods[i].getParameters();
                String[] parameterNames = MServiceParameterParser.getParameterNames((Method)methods[i]);
                for (int j = 0; j < params.length; ++j) {
                    MServiceDefineMeta.ParamDefine pd;
                    KServiceParam kserviceparams = params[j].getAnnotation(KServiceParam.class);
                    if (kserviceparams != null) {
                        pd = MServiceParameterParser.parseParam((String)kserviceparams.paramName(), (Parameter)params[j]);
                        mDefine.addServiceMethodParam(pd);
                        continue;
                    }
                    pd = MServiceParameterParser.parseParam((String)parameterNames[j], (Parameter)params[j]);
                    mDefine.addServiceMethodParam(pd);
                }
            }
        });
        return serviceDefineMap;
    }
}

