/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.define.servicefactory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.instance.Cluster;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.manage.KServiceProviderLoader;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.mservice.spi.define.MServiceDefineSPI;
import kd.bos.mservice.spi.define.MServiceParameterParser;

public class ServiceFactoryMServiceDefine
implements MServiceDefineSPI {
    private static Log log = LogFactory.getLog(ServiceFactoryMServiceDefine.class);

    public Map<String, MServiceDefineMeta> loadMetaDefine() {
        Set<String> serviceNameSet = KServiceProviderLoader.loadKservice(this.type(), this.getClass().getClassLoader());
        HashMap<String, MServiceDefineMeta> serviceDefineMap = new HashMap<String, MServiceDefineMeta>();
        if (serviceNameSet == null || serviceNameSet.size() == 0) {
            return serviceDefineMap;
        }
        long startTime = System.currentTimeMillis();
        log.info("\u52a0\u8f7d\u5e73\u53f0ServiceFactory\u5f00\u59cb\uff1a");
        String bosServiceFactoryClassName = "kd.bos.service.ServiceFactory";
        this.doTransformServiceFactory(serviceNameSet, serviceDefineMap, "bos", "bos", bosServiceFactoryClassName);
        Map cloudAppMap = Cluster.getCloudAppidMapping();
        for (Map.Entry entry : cloudAppMap.entrySet()) {
            String appId = (String)entry.getKey();
            String cloud = ((String)entry.getValue()).toLowerCase();
            String packageName = "kd." + cloud.toLowerCase() + "." + appId.toLowerCase() + ".servicehelper";
            String className = packageName + ".ServiceFactory";
            this.doTransformServiceFactory(serviceNameSet, serviceDefineMap, (String)entry.getKey(), cloud, className);
        }
        long costTime = System.currentTimeMillis() - startTime;
        log.info("\u52a0\u8f7d\u5e73\u53f0ServiceFactory\u7ed3\u675f\uff1a" + costTime);
        return serviceDefineMap;
    }

    private void doTransformServiceFactory(Set<String> serviceNameSet, Map<String, MServiceDefineMeta> serviceDefineMap, String appId, String cloud, String className) {
        try {
            Class<?> serviceFactoryClass = Class.forName(className, false, this.getClass().getClassLoader());
            Field filed = serviceFactoryClass.getDeclaredField("serviceMap");
            filed.setAccessible(true);
            Map map = (Map)filed.get(null);
            map.forEach((serviceName, serviceImplClass) -> {
                if (!serviceNameSet.stream().anyMatch(serviceImplClass::contains)) {
                    return;
                }
                Class<?> mserviceDefineClass = null;
                try {
                    mserviceDefineClass = Class.forName(serviceImplClass, false, this.getClass().getClassLoader());
                }
                catch (Exception e) {
                    return;
                }
                MServiceDefineMeta mdm = new MServiceDefineMeta();
                mdm.setServiceGroupAndName(cloud + "." + appId, serviceName);
                Class<?>[] serviceInterface = mserviceDefineClass.getInterfaces();
                if (serviceInterface.length > 0) {
                    mdm.setServiceInterface(serviceInterface[0].getName());
                }
                mdm.setServiceImplClass(serviceImplClass);
                mdm.setAppIds(new String[]{appId});
                mdm.addTransProtocolTypes("rpc");
                mdm.addDataCodecs("javaobj");
                serviceDefineMap.put(mdm.getServiceName(), mdm);
                Method[] methods = mserviceDefineClass.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    if (!Modifier.isPublic(methods[i].getModifiers())) continue;
                    MServiceDefineMeta.MethodDefine mDefine = new MServiceDefineMeta.MethodDefine();
                    mdm.addMethod(mDefine);
                    mDefine.setServiceMethodName(methods[i].getName());
                    mDefine.setServiceMethodDesc("This is " + methods[i].getName());
                    mDefine.setServiceMethodReturnObjectType(methods[i].getGenericReturnType().getTypeName());
                    mDefine.setServiceMethodReturnParamDefine(MServiceParameterParser.parseParam((Type)methods[i].getGenericReturnType()));
                    Parameter[] parameters = methods[i].getParameters();
                    String[] parameterNames = MServiceParameterParser.getParameterNames((Method)methods[i]);
                    for (int j = 0; j < parameters.length; ++j) {
                        if (parameters == null) continue;
                        MServiceDefineMeta.ParamDefine pd = MServiceParameterParser.parseParam((String)parameterNames[j], (Parameter)parameters[j]);
                        mDefine.addServiceMethodParam(pd);
                    }
                }
            });
        }
        catch (Error | Exception e) {
            return;
        }
    }

    public String type() {
        return "servicefactory";
    }
}

