/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.define.springmvc;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodIntrospector;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class BosMethodIntrospector {
    public static <T> Map<Method, T> selectMethods(Class<?> targetType, MethodIntrospector.MetadataLookup<T> metadataLookup) {
        LinkedHashMap methodMap = new LinkedHashMap();
        LinkedHashSet<Class> handlerTypes = new LinkedHashSet<Class>();
        Class specificHandlerType = null;
        if (!Proxy.isProxyClass(targetType)) {
            specificHandlerType = ClassUtils.getUserClass(targetType);
            handlerTypes.add(specificHandlerType);
        }
        handlerTypes.addAll(ClassUtils.getAllInterfacesForClassAsSet(targetType));
        for (Class currentHandlerType : handlerTypes) {
            Class targetClass = specificHandlerType != null ? specificHandlerType : currentHandlerType;
            ReflectionUtils.doWithMethods((Class)currentHandlerType, method -> {
                Method bridgedMethod;
                Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
                Object result = metadataLookup.inspect(specificMethod);
                if (result != null && ((bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod)) == specificMethod || metadataLookup.inspect(bridgedMethod) == null)) {
                    methodMap.put(specificMethod, result);
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return methodMap;
    }
}

