/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.define.springmvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.define.springmvc.BosMethodIntrospector;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class BosRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<RequestMappingInfo, HandlerMethod> mappingLookup = new LinkedHashMap<RequestMappingInfo, HandlerMethod>();
    private final Map<String, List<MserviceUriMethod>> uriMethodMap = new ConcurrentHashMap<String, List<MserviceUriMethod>>();

    public boolean isHandler(Class<?> beanType) {
        return AnnotatedElementUtils.hasAnnotation(beanType, Controller.class) || AnnotatedElementUtils.hasAnnotation(beanType, RequestMapping.class);
    }

    protected void detectHandlerMethods(Class<?> mserviceDefineClass) {
        Class<?> handlerType = mserviceDefineClass;
        if (handlerType != null) {
            Class userType = ClassUtils.getUserClass(handlerType);
            Map methods = BosMethodIntrospector.selectMethods(userType, method -> {
                try {
                    return super.getMappingForMethod(method, userType);
                }
                catch (Throwable var4) {
                    throw new IllegalStateException("Invalid mapping on handler class [" + userType.getName() + "]: " + method, var4);
                }
            });
            methods.forEach((method, mapping) -> {
                Method invocableMethod = AopUtils.selectInvocableMethod((Method)method, (Class)userType);
                this.register((RequestMappingInfo)mapping, mserviceDefineClass, invocableMethod);
            });
        }
    }

    private void register(RequestMappingInfo mapping, Class<?> handlerType, Method method) {
        Class<?>[] parameterTypes;
        if (KotlinDetector.isKotlinType(method.getDeclaringClass()) && (parameterTypes = method.getParameterTypes()).length > 0 && "kotlin.coroutines.Continuation".equals(parameterTypes[parameterTypes.length - 1].getName())) {
            throw new IllegalStateException("Unsupported suspending handler method detected: " + method);
        }
        this.readWriteLock.writeLock().lock();
        try {
            HandlerMethod handlerMethod = new HandlerMethod(handlerType.newInstance(), method);
            this.validateMethodMapping(handlerMethod, mapping);
            this.mappingLookup.put(mapping, handlerMethod);
            this.putUriMethodMap(mapping, handlerType.getName(), handlerMethod);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void validateMethodMapping(HandlerMethod handlerMethod, RequestMappingInfo mapping) {
        HandlerMethod existingHandlerMethod = this.mappingLookup.get(mapping);
        if (existingHandlerMethod != null && !existingHandlerMethod.equals((Object)handlerMethod)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"BosRequestMappingHandlerMapping mapping. Cannot map '" + handlerMethod.getBean() + "' method \n" + handlerMethod + "\nto " + mapping + ": There is already '" + existingHandlerMethod.getBean() + "' bean method\n" + existingHandlerMethod + " mapped."});
        }
    }

    private void putUriMethodMap(RequestMappingInfo mapping, String serviceName, HandlerMethod handlerMethod) {
        List list = this.uriMethodMap.computeIfAbsent(serviceName, k -> new ArrayList(1));
        list.add(this.createBosUriMethod(mapping, handlerMethod));
    }

    public List<MserviceUriMethod> getBosUriMethods(String serviceName) {
        return this.uriMethodMap.get(serviceName);
    }

    private MserviceUriMethod createBosUriMethod(RequestMappingInfo mapping, HandlerMethod handlerMethod) {
        String str;
        Set patterns = mapping.getPatternsCondition().getPatterns();
        String originalUri = "";
        Iterator iterator = patterns.iterator();
        while (iterator.hasNext() && ((originalUri = (str = (String)iterator.next())) == null || originalUri.length() <= 0)) {
        }
        return new MserviceUriMethod(originalUri, handlerMethod);
    }

    static class MserviceUriMethod {
        String originalUri;
        HandlerMethod handlerMethod;

        MserviceUriMethod(String originalUri, HandlerMethod handlerMethod) {
            this.originalUri = originalUri;
            this.handlerMethod = handlerMethod;
        }

        public String getOriginalUri() {
            return this.originalUri;
        }

        public void setOriginalUri(String originalUri) {
            this.originalUri = originalUri;
        }

        public HandlerMethod getHandlerMethod() {
            return this.handlerMethod;
        }

        public void setHandlerMethod(HandlerMethod handlerMethod) {
            this.handlerMethod = handlerMethod;
        }
    }
}

