/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.manage;

import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.ws.rs.Path;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.annotation.KService;
import kd.bos.mservice.manage.MServiceClassVisitor;
import kd.bos.util.StringUtils;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

public class KServiceProviderLoader {
    private static final Log LOGGER = LogFactory.getLog(KServiceProviderLoader.class);
    private static final String FACTORY_RESOURCES_LOACATION = "META-INF/kservice.factories";
    private static Map<ClassLoader, HashMultimap<String, String>> cache = new ConcurrentHashMap<ClassLoader, HashMultimap<String, String>>(2);
    private static Map<String, Set<String>> TYPE_ANNOTATIONS_MAP = new HashMap<String, Set<String>>();
    private static Set<String> LOADED_CLASSNAME_SET = new HashSet<String>();

    public static Set<String> loadKservice(String type, ClassLoader cloader) {
        HashMultimap mulMap = cache.computeIfAbsent(cloader, k -> {
            HashMultimap map = HashMultimap.create();
            try {
                Enumeration<URL> urls = cloader.getResources(FACTORY_RESOURCES_LOACATION);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    Properties p = new Properties();
                    try (InputStream is = url.openStream();){
                        p.load(is);
                    }
                    KServiceProviderLoader.resolveProperty(p, (HashMultimap<String, String>)map, cloader);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return map;
        });
        return mulMap.get((Object)type);
    }

    private static void resolveProperty(Properties properties, HashMultimap<String, String> map, ClassLoader cloader) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String type = (String)entry.getKey();
            Set<String> supportAnnotationSet = TYPE_ANNOTATIONS_MAP.get(type);
            if (supportAnnotationSet == null) {
                KServiceProviderLoader.resolveResourceMservice(type, properties, map);
                continue;
            }
            KServiceProviderLoader.resolveSpringmvcAndAnnotationMservice(type, supportAnnotationSet, entry, properties, map, cloader);
        }
    }

    private static void resolveSpringmvcAndAnnotationMservice(String type, Set<String> supportAnnotationSet, Map.Entry<?, ?> entry, Properties properties, HashMultimap<String, String> map, ClassLoader cloader) {
        String[] values;
        String value = (String)entry.getValue();
        for (String tempClassName : values = value.split(",|;")) {
            URL url;
            if (!tempClassName.endsWith("*")) {
                LOADED_CLASSNAME_SET.add(tempClassName);
                map.put((Object)type, (Object)tempClassName);
                continue;
            }
            if (!KServiceProviderLoader.checkPackageAvailable(tempClassName)) continue;
            String basePackage = tempClassName.substring(0, tempClassName.length() - 1);
            if (basePackage.endsWith(".")) {
                basePackage = basePackage.substring(0, basePackage.length() - 1);
            }
            if ((url = cloader.getResource(basePackage.replace(".", "/") + "/")) == null) continue;
            String protocol = url.getProtocol();
            if (protocol.equals("jar")) {
                KServiceProviderLoader.asmReadJar(map, type, supportAnnotationSet, url, basePackage);
                continue;
            }
            if (!protocol.equals("file")) continue;
            KServiceProviderLoader.asmReadFile(map, type, supportAnnotationSet, url);
        }
    }

    private static void asmReadJar(HashMultimap<String, String> map, String type, Set<String> supportAnnotationSet, URL url, String basePackage) {
        String jarName = "";
        try (JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();){
            jarName = jar.getName();
            String basePackageFilePath = basePackage.replace('.', '/');
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(basePackageFilePath) || entry.isDirectory()) continue;
                String className = name.replace('/', '.');
                if ((className = className.substring(0, className.length() - 6)).contains("$")) continue;
                ClassReader classReader = new ClassReader(className);
                if (LOADED_CLASSNAME_SET.contains(className)) {
                    return;
                }
                MServiceClassVisitor myClassVisitor = new MServiceClassVisitor(589824, className, supportAnnotationSet);
                classReader.accept((ClassVisitor)myClassVisitor, 2);
                if (!myClassVisitor.isMService()) continue;
                LOADED_CLASSNAME_SET.add(className);
                map.put((Object)type, (Object)className);
            }
        }
        catch (IOException e) {
            LOGGER.error("asmReadJar {} error", (Object)jarName, (Object)e);
        }
    }

    private static void asmReadFile(HashMultimap<String, String> map, String type, Set<String> supportAnnotationSet, URL url) {
        Collection fileList = FileUtils.listFiles((File)new File(url.getPath()), (String[])new String[]{"class"}, (boolean)true);
        for (File tempFile : fileList) {
            String name = tempFile.getName();
            if (name.contains("$")) continue;
            try {
                FileInputStream inputStream = new FileInputStream(tempFile);
                Throwable throwable = null;
                try {
                    ClassReader classReader = new ClassReader((InputStream)inputStream);
                    String className = classReader.getClassName();
                    className = className.replace("/", ".");
                    if (LOADED_CLASSNAME_SET.contains(className)) {
                        return;
                    }
                    MServiceClassVisitor myClassVisitor = new MServiceClassVisitor(589824, className, supportAnnotationSet);
                    classReader.accept((ClassVisitor)myClassVisitor, 2);
                    if (!myClassVisitor.isMService()) continue;
                    LOADED_CLASSNAME_SET.add(className);
                    map.put((Object)type, (Object)className);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("asmReadFile {} error", (Object)tempFile.getName(), (Object)e);
            }
        }
    }

    private static void resolveResourceMservice(String type, Properties properties, HashMultimap<String, String> map) {
        String[] mserviceArray;
        String resourceMservice = properties.getProperty(type);
        if (StringUtils.isEmpty((String)resourceMservice)) {
            return;
        }
        for (String tempClassName : mserviceArray = resourceMservice.split(",|;")) {
            if (!tempClassName.endsWith("*")) {
                map.put((Object)type, (Object)tempClassName);
                LOADED_CLASSNAME_SET.add(tempClassName);
                continue;
            }
            if (!KServiceProviderLoader.checkPackageAvailable(tempClassName)) continue;
            String resourceBasePackage = tempClassName.substring(0, tempClassName.length() - 1);
            if (tempClassName.endsWith(".")) {
                resourceBasePackage = resourceBasePackage.substring(0, resourceBasePackage.length() - 1);
            }
            map.put((Object)type, (Object)resourceBasePackage);
        }
    }

    private static boolean checkPackageAvailable(String basePackage) {
        String[] packageArray = basePackage.split("\\.");
        return packageArray.length > 4;
    }

    static {
        TYPE_ANNOTATIONS_MAP.put("annotation", Collections.singleton(KService.class.getName()));
        TYPE_ANNOTATIONS_MAP.put("jaxrs", Collections.singleton(Path.class.getName()));
        HashSet<String> springmvcAnnotationSet = new HashSet<String>();
        springmvcAnnotationSet.add(Controller.class.getName());
        springmvcAnnotationSet.add(RestController.class.getName());
        TYPE_ANNOTATIONS_MAP.put("springmvc", springmvcAnnotationSet);
    }
}

