/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.manage;

import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class MServiceClassVisitor
extends ClassVisitor {
    private final String className;
    private final Set<String> supportAnnotationSet;
    private boolean isConcrete = false;
    private boolean isMService = false;
    private Set<String> annotationNameSet = new HashSet<String>();

    public MServiceClassVisitor(int api, String className, Set<String> supportAnnotationSet) {
        super(api);
        this.className = className;
        this.supportAnnotationSet = supportAnnotationSet;
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        String nativeAnnotation = descriptor.replaceAll("/", ".");
        String annotationName = nativeAnnotation.substring(1, nativeAnnotation.length() - 1);
        this.annotationNameSet.add(annotationName);
        return super.visitAnnotation(descriptor, visible);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (name.equals("<init>")) {
            this.isConcrete = true;
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    public void visitEnd() {
        if (this.isConcrete) {
            for (String tempAnnotationName : this.annotationNameSet) {
                if (!this.supportAnnotationSet.contains(tempAnnotationName)) continue;
                this.isMService = true;
                break;
            }
        }
        super.visitEnd();
    }

    public String toString() {
        return this.className;
    }

    public boolean isMService() {
        return this.isMService;
    }
}

