/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dts.Output;
import kd.bos.dts.OutputFactory;
import kd.bos.dts.OutputIUD;
import kd.bos.dts.RowInfo;
import kd.bos.dts.ksql.DataDDLSyncValue;
import kd.bos.dts.ksql.DataSqlDeleteSyncValue;
import kd.bos.dts.ksql.DataSqlInsertSyncValue;
import kd.bos.dts.ksql.DataSqlUpdateSyncValue;
import kd.bos.dts.retry.Retry;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;

public class AbstractSqlOutput
implements Output {
    protected DestinationTransRule destinationRule;

    public AbstractSqlOutput(DestinationTransRule destinationRule) {
        this.destinationRule = destinationRule;
    }

    @Override
    public void trans(String type, DataSyncValue value) {
        if (OperationType.DELETE.getName().equals(type)) {
            DataSqlDeleteSyncValue delete = (DataSqlDeleteSyncValue)value;
            List<Object> ids = delete.getIds();
            if (!ids.isEmpty()) {
                Retry.get().retry(this.destinationRule, delete.getEntityNumber(), ids);
            }
        } else if (OperationType.UPDATE.getName().equals(type)) {
            DataSqlUpdateSyncValue update = (DataSqlUpdateSyncValue)value;
            List<Object> ids = update.getIds();
            if (!ids.isEmpty()) {
                Retry.get().retry(this.destinationRule, update.getEntityNumber(), ids);
            }
        } else if (OperationType.INSERT.getName().equals(type)) {
            DataSqlInsertSyncValue insert = (DataSqlInsertSyncValue)value;
            String tableName = insert.getTableName();
            ArrayList<RowInfo> datas = new ArrayList<RowInfo>();
            RowInfo ri = new RowInfo();
            ri.setType(OperationType.INSERT.getName());
            ri.setTable(tableName);
            ri.setKey(insert.getPkValue());
            datas.add(ri);
            List<String> clomns = insert.getClomns();
            List<Object> values = insert.getValues();
            int colSize = clomns.size();
            for (int i = 0; i < colSize; ++i) {
                ri.getData().put(clomns.get(i), values.get(i));
            }
            OutputIUD outputiud = OutputFactory.getOutputterIUD(this.destinationRule);
            try {
                outputiud.insertTrans(datas);
            }
            catch (Exception e) {
                ArrayList<Object> ls = new ArrayList<Object>();
                ls.add(insert.getPkValue());
                Retry.get().send(this.destinationRule, insert.getEntityNumber(), ls);
            }
        } else if (OperationType.DDL.getName().equals(type)) {
            DataDDLSyncValue ddlValue = (DataDDLSyncValue)value;
            OutputIUD outputiud = OutputFactory.getOutputterIUD(this.destinationRule);
            outputiud.ddlTrans(ddlValue.getDDL());
        }
    }

    @Override
    public void reTrans(String type, DataSyncValue value, String configOperateType, String entityfields) {
        this.trans(type, value);
    }
}

