/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts;

import java.util.List;
import java.util.Map;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.config.DtsConfig;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.dts.rateofprogress.RateofprogressFactory;
import kd.bos.dts.retry.RetryStroage;
import kd.bos.dts.service.DtsConfigMonitor;
import kd.bos.dts.syncconfig.SyncConfigCompareInfo;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.datasync.ColumnInfo;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.UpdateDataSyncValue;
import kd.bos.orm.datasync.agent.UpgraderStatus;

public class DtsMsgSender {
    public static void sendWithTranscation(String region, String queue, Map<String, Object> msg, String routeKey) {
        if (DtsMsgSender.checkUpgraderingAndConfigChange(queue, msg)) {
            return;
        }
        MessagePublisher p = MQFactory.get().createSimplePublisher(region, DtsMsgSender.getQueue(queue, msg));
        p.publishInDbTranscation(routeKey, msg);
        p.close();
    }

    public static void send(String region, String queue, Map<String, Object> msg) {
        if (DtsMsgSender.checkUpgraderingAndConfigChange(queue, msg)) {
            return;
        }
        MessagePublisher p = MQFactory.get().createSimplePublisher(region, DtsMsgSender.getQueue(queue, msg));
        p.publish(msg);
        p.close();
    }

    private static boolean checkUpgraderingAndConfigChange(String queue, Map<String, Object> msg) {
        if (UpgraderStatus.status.isUpgradering()) {
            return true;
        }
        if (queue.equalsIgnoreCase("kd.bos.service.dts.init_config_queue") && msg.get("dts_config_change_key") == null) {
            Object value = msg.get("datasyncvalue");
            if (value instanceof UpdateDataSyncValue) {
                UpdateDataSyncValue updateValue = (UpdateDataSyncValue)value;
                String number = updateValue.getEntityNumber();
                String tableName = updateValue.getTableName();
                if ("data_sync_config".equals(number) && "t_dts_datasyncconfig".equalsIgnoreCase(tableName)) {
                    List columnsLs = updateValue.getColumnsLs();
                    boolean hasEnbaleField = false;
                    int columnIndex = -1;
                    for (ColumnInfo columnsL : columnsLs) {
                        if (!columnsL.getFiledName().equalsIgnoreCase("fenable")) continue;
                        hasEnbaleField = true;
                        columnIndex = columnsL.getColumnIndex();
                        break;
                    }
                    if (hasEnbaleField) {
                        List rows = ((UpdateDataSyncValue)value).getRows();
                        List oids = updateValue.getTableOids();
                        int j = 0;
                        for (Object[] row : rows) {
                            Object enableValue = row[columnIndex];
                            long id = (Long)oids.get(j);
                            if (enableValue != null && "0".equals(enableValue.toString())) {
                                SyncConfigInfo scinfo = DtsSnapConfigDao.instance.getConfigInfo(id);
                                if (scinfo != null) {
                                    String entityKey = DtsUtils.getEntitySplitKey(scinfo.getEntitynumber(), DestinationType.getType((String)scinfo.getDestinationtype()).getName(), scinfo.getRegion(), scinfo.getMappingrule());
                                    RateofprogressFactory.get(entityKey).clear();
                                }
                                RetryStroage.get().removeItem(id);
                            }
                            ++j;
                        }
                    }
                }
            }
            DtsConfigMonitor.get().doInitConfig();
            return true;
        }
        return false;
    }

    private static String getQueue(String queue, Map<String, Object> msg) {
        if (DtsUtils.isDtsQueueSplit()) {
            String entityNumber;
            String businessType;
            String type = null;
            if (queue.equalsIgnoreCase("kd.bos.service.dts.init_config_queue")) {
                SyncConfigCompareInfo compare = (SyncConfigCompareInfo)msg.get("dts_config_change_key");
                businessType = compare.getBusinessType();
                entityNumber = compare.getEntitynumber();
            } else if (queue.equalsIgnoreCase("kd.bos.service.dts.sync_data_retry_queue")) {
                DestinationTransRule destRule = (DestinationTransRule)msg.get("destination");
                businessType = destRule.getBusinessType();
                entityNumber = (String)msg.get("entityNumber");
            } else {
                DataSyncValue value = (DataSyncValue)msg.get("datasyncvalue");
                DestinationTransRule rule = (DestinationTransRule)msg.get("destination");
                entityNumber = value.getEntityNumber();
                businessType = rule.getBusinessType();
                type = (String)msg.get("optype");
            }
            String queueName = queue + DtsConfig.get().getDtsQueueSplitKey(businessType, entityNumber);
            StringBuilder stringBuilder = new StringBuilder("kd.bos.dts.DtsMsgSender#send:");
            stringBuilder.append("queueName#").append(queueName);
            stringBuilder.append(",businessType#").append(businessType);
            stringBuilder.append(",entityNumber#").append(entityNumber);
            if (type != null) {
                stringBuilder.append(",type#").append(type);
            }
            DtsUtils.logInfo(stringBuilder.toString());
            return queueName;
        }
        return queue;
    }
}

