/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dts.DtsMsgSender;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;

public class DtsUtils {
    private static final Log logger = LogFactory.getLog(DtsMsgSender.class);
    public static final String MULTTABLE_SUFFIX = "_l";
    public static final String LOCALFILEDNAME = "flocaleid";
    public static final String MULTTABLEPKFIELDNAME = "fpkid";
    public static final String CONNECTSTR = "_";
    private static final boolean IS_QUEUE_SPILT = Boolean.parseBoolean(System.getProperty("dts.queue.split.enable", "true"));
    private static ConcurrentHashMap<String, String> tableNameMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> entityRouteKeyMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ISimpleProperty> entityPKMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, LocaleString> entityLocaleMap = new ConcurrentHashMap();
    private static final String FIELDSPLITSTR = "#";
    private static boolean enableLog = false;

    public static String getTableNameByEntityNumber(String number) {
        return tableNameMap.computeIfAbsent(number, k -> DataCacheReader.get().getDataEntityType(number).getAlias().toLowerCase());
    }

    public static String getEntityPKName(String number) {
        return entityPKMap.computeIfAbsent(number, k -> DataCacheReader.get().getDataEntityType(number).getPrimaryKey()).getName();
    }

    public static boolean isEntityPkyIsInteger(String number) {
        int dbtype = entityPKMap.computeIfAbsent(number, k -> DataCacheReader.get().getDataEntityType(number).getPrimaryKey()).getDbType();
        return 4 == dbtype || -5 == dbtype || 2 == dbtype;
    }

    public static String getEntityPKFiled(String number) {
        return entityPKMap.computeIfAbsent(number, k -> DataCacheReader.get().getDataEntityType(number).getPrimaryKey()).getAlias();
    }

    public static String getDBRoutKeyByEntityNumber(String number) {
        return entityRouteKeyMap.computeIfAbsent(number, k -> DataCacheReader.get().getDataEntityType(number).getDBRouteKey());
    }

    public static String getDisplayNameLocaleValue(String number) {
        if (StringUtils.isEmpty((CharSequence)number)) {
            return null;
        }
        return entityLocaleMap.computeIfAbsent(number, k -> {
            LocaleString ls = null;
            try {
                ls = DataCacheReader.get().getDataEntityType(number).getDisplayName();
            }
            catch (Exception e) {
                ls = new LocaleString(number);
            }
            return ls;
        }).getLocaleValue();
    }

    public static String getEntitySplitKey(String entityNumber, String desttype, String region, String mappingRule) {
        return entityNumber + desttype + region + mappingRule;
    }

    public static boolean dtsEnable() {
        return Boolean.parseBoolean(System.getProperty("dts.sync.enable", "true"));
    }

    public static boolean dtsBizRunEnable() {
        return IS_QUEUE_SPILT && Instance.isAppSplit() && Boolean.parseBoolean(System.getProperty("dts.biz.run.enable", "false"));
    }

    public static String getAppidBuQueueName(String queueName) {
        String[] splits = queueName.split("-");
        String appid = splits[splits.length - 1];
        return appid;
    }

    public static boolean isDtsQueueSplit() {
        return IS_QUEUE_SPILT;
    }

    public static boolean isAsyncInitImportData() {
        return Boolean.parseBoolean(System.getProperty("dts.init.import.async", "false"));
    }

    public static boolean isKsqlLog() {
        return Boolean.parseBoolean(System.getProperty("dts.ksql.log.enable", "false"));
    }

    public static String getDTSElectMode() {
        return System.getProperty("dts.elect.mode", "zookeeper");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Map<String, String>> parseMappingRule(String rule) {
        HashMap<String, Map<String, String>> val = new HashMap<String, Map<String, String>>(1);
        if (rule.indexOf(FIELDSPLITSTR) > 0) {
            String[] filedPairs;
            String[] ruleDetail = rule.split(FIELDSPLITSTR);
            String ruleMapping = ruleDetail[0];
            HashMap<String, String> fileds = new HashMap<String, String>(1);
            val.put(ruleMapping, fileds);
            if (ruleDetail.length != 2) throw new KDException(DtsErrorCode.unsupport, new Object[]{"unsupport EsTransmitter`s mappingRule type:" + rule + " ,filed error : "});
            for (String filedPairStr : filedPairs = ruleDetail[1].split(",|;")) {
                String[] filedKV = filedPairStr.split("=");
                if (filedKV.length != 2) {
                    throw new KDException(DtsErrorCode.unsupport, new Object[]{"unsupport EsTransmitter`s mappingRule type:" + rule + " ,filed error : " + filedPairStr});
                }
                fileds.put(filedKV[0], filedKV[1]);
            }
            return val;
        } else {
            val.put(rule, Collections.emptyMap());
        }
        return val;
    }

    public static List<Account> getAllAccountsOfCurrentEnv() {
        try {
            return AccountUtils.getAllAccountsOfCurrentEnv();
        }
        catch (KDException kdException) {
            ExceptionLogger.log(DtsUtils.class, (String)("can not get account info: " + ExceptionLogger.getStack((Throwable)kdException)));
            return Collections.emptyList();
        }
    }

    public static boolean isSearchAfter() {
        return "searchafter".equals(System.getProperty("elasticsearch.query.model", "searchscroll"));
    }

    public static void logInfo(String lot) {
        if (enableLog) {
            logger.info(lot);
        }
    }

    static {
        ConfigurationUtil.observeBoolean((String)"dts.debug.log", (boolean)false, v -> {
            enableLog = v;
        });
    }
}

