/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts;

import java.util.Map;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.consume.Consumer;
import kd.bos.dts.consume.ConsumerFactory;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.ksql.DataSqlSyncValue;
import kd.bos.dts.log.DtsStatusReporterFactory;
import kd.bos.dts.log.DtsStatusType;
import kd.bos.dts.oplog.Oplog;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;

public class SyncDataConsumer
implements MessageConsumer {
    private Consumer consumer = ConsumerFactory.getConsumer();

    public void onMessage(Object arg0, String arg1, boolean resend, MessageAcker arg3) {
        Map m = (Map)arg0;
        String type = (String)m.get("optype");
        DestinationTransRule destinationType = (DestinationTransRule)m.get("destination");
        DataSyncValue value = (DataSyncValue)m.get("datasyncvalue");
        DestinationRuleConfig entityRuleConfig = DestinationRuleConfig.get((String)value.getEntityNumber(), (DestinationTransRule)destinationType);
        try {
            this.consumer.consum(m);
            DtsStatusReporterFactory.get().realtimeReport(value.getGid(), entityRuleConfig, (value instanceof DataSqlSyncValue ? "Sql " : "") + type, value.getCount(), DtsStatusType.DATA_SYNCED, System.currentTimeMillis() - value.getTimestap());
            String entityNumber = value.getEntityNumber();
            String businessType = destinationType.getBusinessType();
            StringBuilder stringBuilder = new StringBuilder("kd.bos.dts.DtsMsgConsumer#SyncDataConsumer:");
            stringBuilder.append(",businessType#").append(businessType);
            stringBuilder.append(",entityNumber#").append(entityNumber);
            stringBuilder.append(",type#").append(type);
            DtsUtils.logInfo(stringBuilder.toString());
        }
        catch (Exception e) {
            Oplog.get().error(destinationType.getType().getName() + "-" + destinationType.getRegion(), type, value.getEntityNumber(), 0, ExceptionLogger.getStack((Throwable)e));
            DtsStatusReporterFactory.get().realtimeExceptionReport(e, value.getGid(), entityRuleConfig, type, value.getCount(), DtsStatusType.DATA_SYNCED_EXCEPTION, System.currentTimeMillis() - value.getTimestap());
            if (resend) {
                arg3.discard(arg1);
                ExceptionLogger.error(this.getClass(), (String)"dtsmessage consumer error", (Throwable)e);
            } else {
                arg3.deny(arg1);
            }
            return;
        }
    }
}

