/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.caution;

import java.util.HashMap;
import java.util.List;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dts.caution.CautionType;
import kd.bos.dts.caution.GidCaution;
import kd.bos.instance.Instance;
import kd.bos.orm.datasync.gid.Gid;

public class GidCuationRedisImpl
implements GidCaution {
    private String entityKey;
    private String beginKey;
    private String changeFieldKey;
    private String operateKey;
    private String endKey;
    private DistributeSessionlessCache cuationStore;
    private LocalMemoryCache lcache;
    private static final String STORE_KEY = "dts.gidcuation.store." + Instance.getClusterName();
    private long beginNum = -1L;
    private long endNum = -1L;
    private String changeField = "";
    private String operate = "";
    private long rbegin = -1L;
    private long rend = -1L;

    GidCuationRedisImpl(String entityKey) {
        this.entityKey = entityKey;
        this.beginKey = entityKey + "begin";
        this.endKey = entityKey + "end";
        this.changeFieldKey = entityKey + "changeFieldKey";
        this.operateKey = entityKey + "operateKey";
        this.cuationStore = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("dts");
        CacheConfigInfo cacheConfig = new CacheConfigInfo();
        cacheConfig.setTimeout(100);
        cacheConfig.setMaxItemSize(10000);
        cacheConfig.setTimeToLive(true);
        this.lcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(STORE_KEY, STORE_KEY, cacheConfig);
    }

    @Override
    public long begin() {
        List ls = this.cuationStore.get(STORE_KEY, new String[]{this.endKey, this.beginKey});
        if (ls != null && ls.size() == 2 && ls.get(0) != null && ls.get(1) != null) {
            boolean preNotCompleted;
            long preEnd = Long.parseLong((String)ls.get(0));
            boolean bl = preNotCompleted = preEnd == Long.MAX_VALUE;
            if (preNotCompleted) {
                return Long.parseLong((String)ls.get(1));
            }
        }
        this.beginNum = Gid.get().genGid();
        this.endNum = Long.MAX_VALUE;
        this.store();
        return this.beginNum;
    }

    private void store() {
        HashMap<String, String> m = new HashMap<String, String>(4);
        m.put(this.beginKey, String.valueOf(this.beginNum));
        m.put(this.endKey, String.valueOf(this.endNum));
        m.put(this.changeFieldKey, this.changeField);
        m.put(this.operateKey, this.operate);
        this.cuationStore.put(STORE_KEY, m, 172800);
        this.lcache.remove(new String[]{this.entityKey});
    }

    @Override
    public long end() {
        this.endNum = Gid.get().genGid();
        this.store();
        return this.endNum;
    }

    @Override
    public CautionType compare(long gid) {
        this.refulsh();
        if (this.rend == Long.MAX_VALUE) {
            return CautionType.running;
        }
        if (gid < this.rbegin) {
            return CautionType.left;
        }
        if (gid > this.rend) {
            return CautionType.right;
        }
        return CautionType.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refulsh() {
        if (!this.lcache.contains(this.entityKey)) {
            LocalMemoryCache localMemoryCache = this.lcache;
            synchronized (localMemoryCache) {
                List ls = this.cuationStore.get(STORE_KEY, new String[]{this.beginKey, this.endKey, this.changeFieldKey, this.operateKey});
                if (ls != null && !ls.isEmpty() && ls.get(0) != null) {
                    this.rbegin = Long.parseLong((String)ls.get(0));
                    this.rend = Long.parseLong((String)ls.get(1));
                    this.changeField = (String)ls.get(2);
                    this.operate = (String)ls.get(3);
                } else {
                    this.rbegin = -1L;
                    this.rend = -1L;
                    this.changeField = "";
                    this.operate = "";
                }
                this.lcache.put(this.entityKey, (Object)this.entityKey);
            }
        }
    }

    public String toString() {
        return this.entityKey + ": begin=" + this.beginNum + ",end=" + this.endNum;
    }

    @Override
    public String getChangeFields() {
        return this.changeField;
    }

    @Override
    public void setChangeFields(String entityfields) {
        this.changeField = entityfields;
    }

    @Override
    public void setOperationType(String name) {
        this.operate = name;
    }

    @Override
    public String getOperationType() {
        return this.operate;
    }

    @Override
    public void clearAll() {
        this.cuationStore.remove(STORE_KEY);
    }

    @Override
    public boolean isInitializing() {
        this.refulsh();
        return this.rend == Long.MAX_VALUE;
    }
}

