/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.check.address;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dts.check.address.BusinessdbChecker;
import kd.bos.dts.check.address.DestinationChecker;
import kd.bos.dts.check.address.DestinationESChecker;
import kd.bos.dts.check.address.DestinationHbaseChecker;
import kd.bos.dts.check.address.DestinationMongoChecker;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.datasync.DestinationType;

public class DestinationCheckerFactory {
    private static ConcurrentHashMap<String, DestinationChecker> outputMap = new ConcurrentHashMap();

    public static DestinationChecker getChecker(String destType, String region) {
        String key = destType + region;
        return outputMap.computeIfAbsent(key, x -> {
            if (DestinationType.FULLTEXT.getName().equals(destType)) {
                return new DestinationESChecker(region);
            }
            if (DestinationType.HBASE.getName().equals(destType)) {
                return new DestinationHbaseChecker(region);
            }
            if (DestinationType.MONGODB.getName().equals(destType)) {
                return new DestinationMongoChecker(region);
            }
            if (DestinationType.BUSINESSDB.getName().equals(destType)) {
                return new BusinessdbChecker(region);
            }
            throw new KDException(DtsErrorCode.unsupport, new Object[]{"unsupport destination type:" + destType});
        });
    }
}

