/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.check.address;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dts.check.address.DestinationChecker;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.impl.fulltext.access.ESAccess;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class DestinationESChecker
implements DestinationChecker {
    private String region;
    private static LocalMemoryCache cache;
    private String lastErrorInfo = "null";

    public DestinationESChecker(String region) {
        this.region = region;
    }

    @Override
    public boolean isAvailable() {
        boolean isAvailabel;
        Object o = cache.get(this.region);
        if (o != null) {
            return (Boolean)o;
        }
        try {
            ESAccess access = ESAccess.get(this.region);
            isAvailabel = access.check();
        }
        catch (Exception e) {
            ExceptionLogger.error(DestinationESChecker.class, (String)"eschecker error ", (Throwable)e);
            isAvailabel = false;
            this.lastErrorInfo = ExceptionLogger.getStack((Throwable)e);
        }
        cache.put(this.region, (Object)isAvailabel);
        return isAvailabel;
    }

    @Override
    public String getAddrString() {
        return ESAccess.get(this.region).getAddressStr();
    }

    @Override
    public String getLastCheckInfo() {
        return this.lastErrorInfo;
    }

    static {
        try {
            CacheConfigInfo cc = new CacheConfigInfo();
            cc.setMaxItemSize(10);
            cc.setTimeout(3);
            cc.setTimeToLive(true);
            cache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("bos", DestinationESChecker.class.getName(), cc);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }
}

