/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.check.consistence;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dts.check.consistence.ConsistenceChecker;
import kd.bos.extension.ExtensionFactory;
import kd.bos.orm.datasync.DestinationTransRule;

public class ConsistenceCheckerFactory {
    private static ConcurrentHashMap<String, ConsistenceChecker> outputMap = new ConcurrentHashMap();
    private static ExtensionFactory<ConsistenceChecker> lookupFactory = ExtensionFactory.getExtensionFacotry(ConsistenceChecker.class);

    public static ConsistenceChecker getChecker(DestinationTransRule ruleType) {
        String destType = ruleType.getType().getName();
        String region = ruleType.getRegion();
        String mappingRule = ruleType.getMappingrule();
        String key = destType + region + mappingRule;
        return outputMap.computeIfAbsent(key, x -> {
            ConsistenceChecker creator;
            if (mappingRule != null && mappingRule.length() > 0) {
                try {
                    creator = (ConsistenceChecker)lookupFactory.getExtension(destType + "." + mappingRule, false);
                }
                catch (Exception e) {
                    creator = (ConsistenceChecker)lookupFactory.getExtension(destType, false);
                }
            } else {
                creator = (ConsistenceChecker)lookupFactory.getExtension(destType, false);
            }
            creator.setRegion(ruleType.getRegion());
            return creator;
        });
    }
}

