/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.config;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.DtsQueueSplitType;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.config.UpgraderColumnAppid;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.orm.datasync.agent.BusinessTypeEnable;
import kd.bos.orm.datasync.agent.RelationTablesCache;
import kd.bos.util.StringUtils;

public class DtsConfig {
    private static Log logger = LogFactory.getLog(DtsConfig.class);
    private static Map<String, DtsConfig> instances = new ConcurrentHashMap<String, DtsConfig>(2);
    private ConcurrentHashMap<String, String> appidNameMap = new ConcurrentHashMap(8);
    private Set<String> businesstypes = new HashSet<String>();
    private ConcurrentHashMap<String, String> businesstypeSplitTypeMap = new ConcurrentHashMap(8);
    private Map<String, Set<String>> businesstypeEntitiesMap = new ConcurrentHashMap<String, Set<String>>(16);
    private Set<String> splitKeys = new HashSet<String>();
    private ConcurrentHashMap<String, String> businesstypeEntitySplitMap = new ConcurrentHashMap(8);

    private DtsConfig() {
    }

    public static DtsConfig get() {
        String accountId = RequestContext.get().getAccountId();
        return instances.computeIfAbsent(accountId, v -> new DtsConfig());
    }

    public Set<String> getDtsQueueSplitKeys() {
        return this.splitKeys;
    }

    public void addDtsQueyeSplitKey(String splitKey) {
        this.splitKeys.add(splitKey);
    }

    public void initDtsQueueSplitKeys() {
        Set<String> businesstypes = this.getBusinesstypes();
        for (String businesstype : businesstypes) {
            Set<String> entities = this.getBusinesstypeEntities(businesstype);
            entities.forEach(entityNumber -> {
                String splitKey = this.getDtsQueueSplitKey(businesstype, (String)entityNumber);
                this.splitKeys.add(splitKey);
            });
        }
    }

    public String getDtsQueueSplitKey(String businesstype, String entityNumber) {
        if (StringUtils.isEmpty((String)businesstype) || StringUtils.isEmpty((String)entityNumber)) {
            throw new KDException(DtsErrorCode.cannotbenull, new Object[]{"businesstype and entityNumber"});
        }
        String businesstypeEntityKey = businesstype + "#" + entityNumber;
        return this.businesstypeEntitySplitMap.computeIfAbsent(businesstypeEntityKey, item -> {
            StringBuilder sb = new StringBuilder();
            String splitType = this.getBusinesstypeSplitType(businesstype);
            DtsQueueSplitType queueSplitType = DtsQueueSplitType.getType(splitType);
            sb.setLength(0);
            sb.append("-").append(RequestContext.get().getAccountId());
            if (queueSplitType == DtsQueueSplitType.businesstype) {
                sb.append("-").append(businesstype);
            } else if (queueSplitType == DtsQueueSplitType.cloud) {
                sb.append("-").append(businesstype);
                sb.append("-").append(DtsConfig.get().getCloudidByEntityNumber(entityNumber));
            } else if (queueSplitType == DtsQueueSplitType.application) {
                sb.append("-").append(businesstype);
                sb.append("-").append(DtsConfig.get().getAppidByEntityNumber(entityNumber));
            } else if (queueSplitType == DtsQueueSplitType.entity) {
                sb.append("-").append(businesstype);
                sb.append("-").append(entityNumber);
            }
            return sb.toString();
        });
    }

    public String getBusinesstypeSplitType(String businesstype) {
        return this.businesstypeSplitTypeMap.computeIfAbsent(businesstype, item -> {
            if (DtsUtils.dtsBizRunEnable()) {
                return DtsQueueSplitType.application.getName();
            }
            boolean businesstypeSplitEnable = Boolean.parseBoolean(System.getProperty(String.format("dts.queue.split.%s.enable", businesstype), "false"));
            if (businesstypeSplitEnable) {
                return System.getProperty(String.format("dts.queue.split.%s.type", businesstype), DtsQueueSplitType.businesstype.getName());
            }
            return DtsQueueSplitType.account.getName();
        });
    }

    public void initDtsConfig() {
        String sql = " select distinct fbusinesstype,fentitynumber,fstatus from t_dts_datasyncconfig where fenable='1' and fstatus != 'stopped' ";
        try (DtsExcludeSyncContext ignored = DtsExcludeSyncContext.create();
             TXHandle h = TX.requiresNew();){
            DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[0], rs -> {
                try {
                    while (rs.next()) {
                        String businesstype = rs.getString("fbusinesstype");
                        if (!BusinessTypeEnable.instance.isBusinessTypeEnable(businesstype)) continue;
                        this.businesstypes.add(businesstype);
                        this.getBusinesstypeSplitType(businesstype);
                        String entityNumber = rs.getString("fentitynumber");
                        Set tableNames = RelationTablesCache.get().getTableNamesByEntityNumber(entityNumber);
                        for (String tableName : tableNames) {
                            RelationTablesCache.get().putTableNameEntityNumber(tableName, entityNumber);
                        }
                        Set<String> entities = this.businesstypeEntitiesMap.get(businesstype);
                        if (entities == null) {
                            entities = new HashSet<String>(2);
                            this.businesstypeEntitiesMap.putIfAbsent(businesstype, entities);
                        }
                        entities.add(entityNumber);
                        this.appidNameMap.computeIfAbsent(entityNumber, k -> this.getDefaultAppid(entityNumber));
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return null;
            });
        }
        catch (Exception e) {
            String msg = String.format("dtserror:%s;  sql:%s", e.getMessage(), sql);
            logger.error(msg, (Throwable)e);
        }
        this.initDtsQueueSplitKeys();
    }

    public Set<String> getBusinesstypes() {
        return this.businesstypes;
    }

    public Set<String> getBusinesstypeEntities(String businesstype) {
        return this.businesstypeEntitiesMap.get(businesstype);
    }

    public String getAppidByEntityNumber(String entityNumber) {
        return this.appidNameMap.computeIfAbsent(entityNumber, k -> this.getDefaultAppid(entityNumber));
    }

    public String getCloudidByEntityNumber(String entityNumber) {
        return "";
    }

    private String getDefaultAppid(String entityNumber) {
        String appid = " ";
        if (UpgraderColumnAppid.isUpgraded()) {
            appid = this.getAppidFromTableConfig(entityNumber);
            if (StringUtils.isEmpty((String)appid) && StringUtils.isNotEmpty((String)(appid = DataCacheReader.get().getAppid(entityNumber)))) {
                this.updateAppidToTablesConfig(entityNumber, appid);
            }
        } else {
            appid = DataCacheReader.get().getAppid(entityNumber);
        }
        return appid;
    }

    /*
     * Exception decompiling
     */
    private String getAppidFromTableConfig(String entityNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateAppidToTablesConfig(String entityNumber, String appid) {
        String updateSql = "UPDATE T_DTS_TABLE_CONFIG SET FAPPID = ? WHERE FENTITYNUMBER = ? ";
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();
             TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)"UPDATE T_DTS_TABLE_CONFIG SET FAPPID = ? WHERE FENTITYNUMBER = ? ", (Object[])new Object[]{appid, entityNumber});
        }
    }

    private static /* synthetic */ String lambda$getAppidFromTableConfig$7(ResultSet rs) throws Exception {
        if (rs.next()) {
            return rs.getString("FAPPID");
        }
        return null;
    }
}

