/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.consume.impl;

import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import kd.bos.dts.DtsMsgSender;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.Output;
import kd.bos.dts.OutputFactory;
import kd.bos.dts.caution.CautionType;
import kd.bos.dts.caution.GidCaution;
import kd.bos.dts.caution.GidCautionFactory;
import kd.bos.dts.ksql.DataSqlSyncValue;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;

public class ConsumeExecutor {
    private static final String WAITINGQUEUE = "waitingqueue";

    public static void consume(Map<String, Object> m) {
        String type = (String)m.get("optype");
        DestinationTransRule destinationType = (DestinationTransRule)m.get("destination");
        DataSyncValue value = (DataSyncValue)m.get("datasyncvalue");
        Output out = value instanceof DataSqlSyncValue ? OutputFactory.getSqlOutputter(destinationType) : OutputFactory.getOutputter(destinationType);
        String selfEntityNumber = value.getEntityNumber();
        String mainEntityNumber = out.getMainEntity(selfEntityNumber);
        String typeName = destinationType.getType().getName();
        String region = destinationType.getRegion();
        String mappingRule = destinationType.getMappingrule();
        String ckey = DtsUtils.getEntitySplitKey(mainEntityNumber, typeName, region, mappingRule);
        GidCaution guation = GidCautionFactory.get(ckey);
        CautionType cautionType = guation.compare(value.getGid());
        boolean isFromWaitingQueue = m.containsKey(WAITINGQUEUE);
        while (CautionType.running == cautionType) {
            if (!isFromWaitingQueue) {
                m.put(WAITINGQUEUE, WAITINGQUEUE);
                DtsMsgSender.send("dts", "kd.bos.service.dts.sync_data_waitinitqueue", m);
                return;
            }
            LockSupport.parkNanos(1000000000L);
            cautionType = guation.compare(value.getGid());
        }
        if (CautionType.right == cautionType) {
            out.trans(type, value);
        } else if (CautionType.left == cautionType || CautionType.in == cautionType) {
            if (!mainEntityNumber.equals(selfEntityNumber)) {
                ckey = DtsUtils.getEntitySplitKey(selfEntityNumber, typeName, region, mappingRule);
                guation = GidCautionFactory.get(ckey);
            }
            out.reTrans(type, value, guation.getOperationType(), guation.getChangeFields());
        }
    }
}

