/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.consume.impl.storageQueue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dts.consume.CAccountInfo;
import kd.bos.dts.consume.impl.ConsumeExecutor;
import kd.bos.dts.consume.impl.storageQueue.QueueItem;
import kd.bos.dts.consume.impl.storageQueue.StorageQueue;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DeleteDataSyncValue;
import kd.bos.orm.datasync.InsertDataSyncValue;
import kd.bos.orm.datasync.UpdateDataSyncValue;

public class DtsDataConsumerAsyncTask<E>
implements Runnable {
    private final StorageQueue<E> storageQueue;
    private CAccountInfo cinfo;

    public DtsDataConsumerAsyncTask(CAccountInfo cinfo, StorageQueue<E> storageQueue) {
        this.storageQueue = storageQueue;
        this.cinfo = cinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DtsDataConsumerAsyncTask dtsDataConsumerAsyncTask = this;
        synchronized (dtsDataConsumerAsyncTask) {
            RequestContext rc = RequestContext.getOrCreate();
            rc.setAccountId(this.cinfo.getAccountid());
            rc.setTenantId(this.cinfo.getTenantid());
            List<QueueItem<E>> ls = this.storageQueue.dequeue();
            ArrayList<Object> rls = new ArrayList<Object>();
            HashMap<String, Object> rmap = new HashMap<String, Object>();
            for (QueueItem<E> qi : ls) {
                Map message = (Map)qi.getValue();
                this.parse(rls, rmap, message);
                ConsumeExecutor.consume(message);
                this.storageQueue.ack(qi.getMessageId());
            }
        }
    }

    private void parse(List<Object> rls, Map<String, Object> rmap, Map<String, Object> message) {
        DataSyncValue value = (DataSyncValue)message.get("datasyncvalue");
        if (!(value instanceof InsertDataSyncValue || value instanceof UpdateDataSyncValue || value instanceof DeleteDataSyncValue)) {
            rls.add(value);
        }
    }
}

