/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.consume.impl.storageQueue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.algo.util.OutUtil;
import kd.bos.dts.consume.CAccountInfo;
import kd.bos.dts.consume.impl.storageQueue.DtsDataConsumerAsyncTask;
import kd.bos.dts.consume.impl.storageQueue.QueueConsumeExecutor;
import kd.bos.dts.consume.impl.storageQueue.QueueItem;
import kd.bos.dts.consume.impl.storageQueue.QueueMeta;
import kd.bos.dts.consume.impl.storageQueue.StorageQueueStaus;
import kd.bos.dts.exception.ExceptionLogger;

public class StorageQueue<E> {
    private QueueMeta queueMeta;
    private final DtsDataConsumerAsyncTask<E> task;
    private LinkedBlockingQueue<QueueItem<E>> queue = new LinkedBlockingQueue(2000);
    private static int maxPatch = 5000;
    private static volatile AtomicLong _id = new AtomicLong(0L);

    public StorageQueue(CAccountInfo cinfo) {
        this.task = new DtsDataConsumerAsyncTask(cinfo, this);
        this.queueMeta = StorageQueueStaus.getQueueMeta(cinfo);
    }

    public void enqueue(E obj) {
        try {
            QueueItem<E> qi = new QueueItem<E>(obj);
            QueueConsumeExecutor.addTask(this.task);
            qi.setMessageId(_id.incrementAndGet());
            this.queue.put(qi);
        }
        catch (InterruptedException e) {
            ExceptionLogger.error(StorageQueue.class, (String)"enqueue error", (Throwable)e);
        }
        this.queueMeta.setEndIndex(0L);
    }

    public List<QueueItem<E>> dequeue() {
        ArrayList<QueueItem<E>> preSendLs = new ArrayList<QueueItem<E>>(8);
        if (this.queue.size() > 0) {
            this.queue.drainTo(preSendLs, maxPatch);
        }
        return preSendLs;
    }

    public void ack(long messageid) {
        OutUtil.getSystemOut().println("ack message " + _id);
    }
}

