/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.controller;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.config.change.DtsConfigChangeNotifier;
import kd.bos.dts.service.DtsAccountPowerMasterListenerImpl;
import kd.bos.dts.service.DtsConfigChangeMasterListenerImpl;
import kd.bos.dts.service.DtsMQueueDefManager;
import kd.bos.elect.ElectorListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.QueueManager;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.datasync.DtsAccountPowerListener;

public class ConsumerControllerListener
implements ElectorListener {
    private static final Log log = LogFactory.getLog(ConsumerControllerListener.class);
    private static final AtomicBoolean isStarted = new AtomicBoolean(false);
    private String appid;

    public ConsumerControllerListener(String appid) {
        this.appid = appid;
    }

    public void notifyMaster() {
        if (isStarted.compareAndSet(false, true)) {
            if (DtsUtils.dtsBizRunEnable()) {
                Set<String> queueNames = DtsMQueueDefManager.getAppidDtsQueueNames(this.appid);
                for (String queueName : queueNames) {
                    Consumer conumer = QueueManager.getLazyInitConsumer((String)"dts", (String)queueName);
                    DtsMQueueDefManager.start(conumer);
                }
            } else {
                Set<String> queueNames = DtsMQueueDefManager.getDtsQueueNames();
                for (String queueName : queueNames) {
                    Consumer conumer = QueueManager.getLazyInitConsumer((String)"dts", (String)queueName);
                    DtsMQueueDefManager.start(conumer);
                }
            }
        } else {
            log.info("dts all consumer is started");
        }
        DtsAccountPower.registerListener((DtsAccountPowerListener)new DtsAccountPowerMasterListenerImpl(this.appid));
        DtsConfigChangeNotifier.registerListener(new DtsConfigChangeMasterListenerImpl(this.appid));
    }

    public void notifyLostMaster() {
        if (isStarted.compareAndSet(true, false)) {
            if (DtsUtils.dtsBizRunEnable()) {
                Set<String> queueNames = DtsMQueueDefManager.getAppidDtsQueueNames(this.appid);
                for (String queueName : queueNames) {
                    Consumer conumer = QueueManager.getLazyInitConsumer((String)"dts", (String)queueName);
                    DtsMQueueDefManager.stop(conumer);
                }
            } else {
                Set<String> queueNames = DtsMQueueDefManager.getDtsQueueNames();
                for (String queueName : queueNames) {
                    Consumer conumer = QueueManager.getLazyInitConsumer((String)"dts", (String)queueName);
                    DtsMQueueDefManager.stop(conumer);
                }
            }
        } else {
            log.warn("dts all consumer didn't start or all consumer has stopped");
        }
        DtsAccountPower.removeListener((String)DtsAccountPowerMasterListenerImpl.class.getName());
        DtsConfigChangeNotifier.removeListener(DtsConfigChangeMasterListenerImpl.class.getName());
    }
}

