/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.impl.fulltext.access;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dts.RowInfo;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.impl.fulltext.Mapper;
import kd.bos.dts.impl.fulltext.access.highlevel.HighLevelAccess;
import kd.bos.exception.KDException;
import org.elasticsearch.index.query.QueryBuilder;

public interface ESAccess {
    public static ESAccess get(String region) {
        String type;
        if (region == null || region.length() == 0) {
            region = "quicksearch";
        }
        if ("jest".equals(type = System.getProperty("dts.fulltext.accesstype"))) {
            throw new KDException(DtsErrorCode.unsupport, new Object[0]);
        }
        if ("highlevel".equals(type)) {
            return HighLevelAccess.get(region);
        }
        return HighLevelAccess.get(region);
    }

    public boolean deleteIndex(String var1);

    public void applyRows(String var1, List<RowInfo> var2, String var3, Mapper var4);

    public List<Map<String, String>> query(String var1, String var2, String[] var3, int var4, int var5);

    public List<Map<String, String>> query(String var1, String var2, String[] var3, QueryBuilder var4, int var5, int var6);

    default public List<Map<String, String>> querySearchAfter(String index, String type, String[] fields, QueryBuilder where, Object after, int size) {
        return Collections.emptyList();
    }

    default public void querySearchScroll(String index, String type, String[] fields, QueryBuilder where, int batch, Consumer<List<Map<String, String>>> consumer) {
    }

    public long queryCount(String var1, String var2, String var3);

    public long deleteByQuery(String var1, String var2, QueryBuilder var3);

    public boolean check();

    public String getAddressStr();

    public void setMaxWindow(String var1, int var2);
}

