/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.impl.fulltext.access.highlevel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kd.bos.dts.RowInfo;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.impl.fulltext.Mapper;
import kd.bos.dts.impl.fulltext.access.ESAccess;
import kd.bos.dts.impl.fulltext.mapping.EsConfigMonitor;
import kd.bos.dts.storage.es.ESQuery;
import kd.bos.elasticsearch.api.ESStorage;
import kd.bos.elasticsearch.client.BosRestHighLevelClient;
import kd.bos.elasticsearch.exception.BosElasticSearchException;
import kd.bos.elasticsearch.factory.ElasticSearchFactory;
import kd.bos.elasticsearch.request.ESColumn;
import kd.bos.elasticsearch.request.ESRow;
import kd.bos.elasticsearch.util.ESUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighLevelAccess
implements ESAccess {
    private static final Logger logger = LoggerFactory.getLogger(HighLevelAccess.class);
    private String region;
    private static Map<String, HighLevelAccess> instances = new ConcurrentHashMap<String, HighLevelAccess>();
    private RestHighLevelClient client;
    private ESStorage esStorage;
    private int version;

    public HighLevelAccess(String region) {
        this.region = region;
        this.initClient();
    }

    private void initClient() {
        this.client = ElasticSearchFactory.getEsClient((String)this.region);
        try {
            MainResponse info = this.client.info(RequestOptions.DEFAULT);
            this.version = info.getVersion().major;
        }
        catch (IOException e) {
            this.version = 6;
        }
        if (this.client instanceof BosRestHighLevelClient) {
            RestClient restClient = ((BosRestHighLevelClient)this.client).getRestClient();
            this.esStorage = ESStorage.create((RestClient)restClient);
        } else {
            this.esStorage = ESStorage.create((String)this.region);
        }
    }

    public static ESAccess get(String region) {
        return instances.computeIfAbsent(region, i -> new HighLevelAccess(region));
    }

    @Override
    public boolean deleteIndex(String indexName) {
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        request.timeout(TimeValue.timeValueMinutes((long)5L));
        request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
        request.indicesOptions(IndicesOptions.lenientExpandOpen());
        try {
            AcknowledgedResponse deleteIndexResponse = this.client.indices().delete(request, RequestOptions.DEFAULT);
            boolean acknowledged = deleteIndexResponse.isAcknowledged();
            return acknowledged;
        }
        catch (ElasticsearchException exception) {
            if (exception.status() == RestStatus.NOT_FOUND) {
                logger.warn("HighLevelAccess not found deleteIndex: " + indexName);
            }
            throw new KDException((Throwable)exception, DtsErrorCode.ioError, new Object[]{"deleteIndex error"});
        }
        catch (IOException exception) {
            throw new KDException((Throwable)exception, DtsErrorCode.ioError, new Object[]{"deleteIndex error"});
        }
        return false;
    }

    private List<RowInfo> handRowInfo(List<RowInfo> rowInfos) {
        EsConfigMonitor.get(this.region).init();
        String tableName = rowInfos.get(0).getTable();
        EsConfigMonitor configmonitor = EsConfigMonitor.get(this.region);
        Set<String> entitys = configmonitor.getEntityNames(tableName);
        int entityCount = 0;
        boolean hasMultiEntitys = entitys.size() > 1;
        ArrayList tempRows = new ArrayList(4);
        for (String entityNumber : entitys) {
            if (entityCount++ == 0) {
                rowInfos.forEach(row -> {
                    row.setEntityNumber(entityNumber);
                    if (hasMultiEntitys) {
                        tempRows.add(row.copyWithDataShared());
                    }
                });
                continue;
            }
            tempRows.forEach(row -> {
                row.setEntityNumber(entityNumber);
                rowInfos.add(row.copyWithDataShared());
            });
        }
        return rowInfos;
    }

    @Override
    public void applyRows(String index, List<RowInfo> esconsumers, String type, Mapper mapper) {
        block27: {
            try (TraceSpan span = Tracer.create((String)"ESWrite", (String)"applyRows");){
                JSONArray items;
                String message;
                esconsumers = this.handRowInfo(esconsumers);
                esconsumers = mapper.preHandle(esconsumers);
                if (esconsumers == null || esconsumers.isEmpty()) {
                    return;
                }
                HashMap<String, String> keyMap = new HashMap<String, String>(4);
                ArrayList<String> deletePks = new ArrayList<String>(8);
                ArrayList<ESRow> rows = new ArrayList<ESRow>(8);
                for (RowInfo row : esconsumers) {
                    String id = mapper.getKeyId(row);
                    keyMap.put(id, String.valueOf(row.getKey()));
                    if (row.getType().equalsIgnoreCase("insert") || row.getType().equalsIgnoreCase("update")) {
                        ESColumn pkColumn = new ESColumn("id", (Object)id);
                        Map map = mapper.convert2Es(row.getTable(), row);
                        if (map == null || map.isEmpty()) continue;
                        ArrayList columns = new ArrayList();
                        map.entrySet().forEach(obj -> {
                            Map.Entry entry = (Map.Entry)obj;
                            Object key = entry.getKey();
                            Object value = entry.getValue();
                            ESColumn column = new ESColumn((String)key, this.toLowerCawe(value, row.getEntityNumber()));
                            columns.add(column);
                        });
                        ESRow esRow = new ESRow(pkColumn, columns);
                        rows.add(esRow);
                        continue;
                    }
                    deletePks.add(id);
                }
                ArrayList rfailureIds = new ArrayList(1);
                StringBuilder builder = new StringBuilder();
                if (!deletePks.isEmpty()) {
                    try {
                        this.esStorage.deleteByPk(index, type, deletePks);
                    }
                    catch (Exception e) {
                        logger.error("HighLevelAccess deleteByPk error: " + e.getMessage(), (Throwable)e);
                        if (e instanceof BosElasticSearchException) {
                            message = e.getMessage();
                            items = JSONArray.parseArray((String)message);
                            if (items != null && items.size() > 0) {
                                items.forEach(json -> {
                                    JSONObject item = (JSONObject)json;
                                    if (item.size() > 0) {
                                        int id = item.getIntValue("_id");
                                        rfailureIds.add(id);
                                        JSONObject error = item.getJSONObject("error");
                                        if (error != null && error.size() > 0) {
                                            builder.append(item.getJSONObject("error").toJSONString()).append("\n");
                                        }
                                    }
                                });
                            }
                        }
                        throw e;
                    }
                }
                if (rows.isEmpty()) break block27;
                try {
                    this.esStorage.save(index, type, rows);
                }
                catch (Exception e) {
                    if (e instanceof BosElasticSearchException) {
                        message = e.getMessage();
                        items = JSONArray.parseArray((String)message);
                        if (items != null && items.size() > 0) {
                            items.forEach(json -> {
                                JSONObject item = (JSONObject)json;
                                if (item.size() > 0) {
                                    int id = item.getIntValue("_id");
                                    rfailureIds.add(id);
                                    JSONObject error = item.getJSONObject("error");
                                    if (error != null && error.size() > 0) {
                                        builder.append(item.getJSONObject("error").toJSONString()).append("\n");
                                    }
                                }
                            });
                        }
                        break block27;
                    }
                    throw e;
                }
            }
        }
    }

    @Override
    @Deprecated
    public List<Map<String, String>> query(String index, String type, String[] fields, int from, int size) {
        return this.query(index, type, fields, null, from, size);
    }

    @Override
    public List<Map<String, String>> query(String index, String type, String[] fields, QueryBuilder where, int from, int size) {
        SearchRequest req = new SearchRequest(new String[]{index});
        SearchSourceBuilder builder = new SearchSourceBuilder();
        if (this.version <= 6) {
            req.types(new String[]{type});
        }
        if (where != null) {
            builder.query(where).from(from).size(size);
        } else {
            builder.query((QueryBuilder)QueryBuilders.matchAllQuery()).from(from).size(size);
        }
        req.source(builder);
        try {
            SearchResponse res = this.client.search(req, RequestOptions.DEFAULT);
            SearchHit[] hits = res.getHits().getHits();
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(4);
            for (SearchHit hit : hits) {
                Map source = hit.getSourceAsMap();
                HashMap<String, String> row = new HashMap<String, String>(4);
                for (String field : fields) {
                    Object v = source.get(field);
                    if (v == null) continue;
                    row.put(field, v.toString());
                }
                result.add(row);
            }
            return result;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, DtsErrorCode.ioError, new Object[]{"HighLevelAccess.query error"});
        }
    }

    @Override
    public List<Map<String, String>> querySearchAfter(String index, String type, String[] fields, QueryBuilder where, Object after, int size) {
        String sortField = "_id";
        SearchRequest req = new SearchRequest(new String[]{index});
        SearchSourceBuilder builder = new SearchSourceBuilder();
        if (this.version <= 6) {
            req.types(new String[]{type});
        }
        if (where != null) {
            builder.query(where).from(0).size(size);
        } else {
            builder.query((QueryBuilder)QueryBuilders.matchAllQuery()).from(0).size(size);
        }
        if (after == null) {
            if (this.version <= 6) {
                builder.sort(sortField);
            }
            builder.searchAfter();
        } else {
            if (this.version <= 6) {
                builder.sort(sortField);
            }
            builder.searchAfter(new Object[]{after});
        }
        req.source(builder);
        try {
            SearchResponse res = this.client.search(req, RequestOptions.DEFAULT);
            SearchHit[] hits = res.getHits().getHits();
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(4);
            for (SearchHit hit : hits) {
                Map source = hit.getSourceAsMap();
                HashMap<String, String> row = new HashMap<String, String>(4);
                for (String field : fields) {
                    Object v = source.get(field);
                    if (v == null) continue;
                    row.put(field, v.toString());
                }
                row.put(sortField, hit.getId());
                result.add(row);
            }
            return result;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, DtsErrorCode.ioError, new Object[]{"HighLevelAccess.query error"});
        }
    }

    @Override
    public void querySearchScroll(String index, String type, String[] fields, QueryBuilder where, int batch, Consumer<List<Map<String, String>>> consumer) {
        String sortField = "_doc";
        SearchSourceBuilder builder = new SearchSourceBuilder();
        if (where != null) {
            builder.query(where).size(batch);
        } else {
            builder.query((QueryBuilder)QueryBuilders.matchAllQuery()).size(batch);
        }
        builder.sort(sortField);
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)30L));
        SearchRequest req = new SearchRequest().indices(new String[]{index});
        if (this.version <= 6) {
            req.types(new String[]{type});
        }
        req.scroll(scroll).source(builder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.client.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            logger.error("scrollRequest error", (Throwable)e);
        }
        if (searchResponse == null || searchResponse.getHits() == null) {
            logger.warn("scrollRequest searchResponse or hits is null");
            return;
        }
        String scrollId = searchResponse.getScrollId();
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList result = new ArrayList(4);
        while (hits != null && hits.length > 0) {
            TraceSpan span = Tracer.create((String)"querySearchScroll.scrollPage2", (String)"scrollPage");
            Throwable throwable = null;
            try {
                for (SearchHit hit : hits) {
                    Map source = hit.getSourceAsMap();
                    HashMap<String, String> row = new HashMap<String, String>(4);
                    for (String field : fields) {
                        Object v = source.get(field);
                        if (v == null) continue;
                        row.put(field, v.toString());
                    }
                    result.add(row);
                }
                consumer.accept(result);
                result.clear();
                SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
                scrollRequest.scroll(scroll);
                try {
                    searchResponse = this.client.scroll(scrollRequest, RequestOptions.DEFAULT);
                }
                catch (IOException e) {
                    logger.error("scrollRequest error", (Throwable)e);
                }
                if (searchResponse == null || searchResponse.getHits() == null) {
                    logger.warn("scrollRequest searchResponse or hits is null");
                    return;
                }
                scrollId = searchResponse.getScrollId();
                hits = searchResponse.getHits().getHits();
            }
            catch (Throwable scrollRequest) {
                throwable = scrollRequest;
                throw scrollRequest;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                span.close();
            }
        }
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        ClearScrollResponse clearScrollResponse = null;
        try {
            clearScrollResponse = this.client.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            logger.error("clearScroll error", (Throwable)e);
        }
        if (clearScrollResponse == null) {
            logger.error("scrollRequest clearScrollResponse is null");
            return;
        }
        boolean succeeded = clearScrollResponse.isSucceeded();
        logger.info("clearScrollResponse:" + succeeded);
    }

    @Override
    public long deleteByQuery(String index, String type, QueryBuilder filterQb) {
        DeleteByQueryRequest req = new DeleteByQueryRequest(new String[]{index});
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.typeQuery((String)type));
        queryBuilder.must(filterQb);
        ((DeleteByQueryRequest)req.setQuery((QueryBuilder)queryBuilder).setRefresh(true)).indices(new String[]{index});
        BulkByScrollResponse res = null;
        try {
            res = this.client.deleteByQuery(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, DtsErrorCode.ioError, new Object[]{"deleteByQuery error"});
        }
        return res.getDeleted();
    }

    @Override
    public boolean check() {
        try {
            GetAliasesRequest request = new GetAliasesRequest();
            GetAliasesResponse getAliasesResponse = this.client.indices().getAlias(request, RequestOptions.DEFAULT);
            Map map = getAliasesResponse.getAliases();
            Set indices = map.keySet();
            logger.info(String.format("dts es livness check,get %s indices", indices.size()));
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
        return true;
    }

    @Override
    public String getAddressStr() {
        Map configMap = ESUtil.getServerConfig((String)this.region);
        String ipPort = (String)configMap.get("host");
        return ipPort;
    }

    @Override
    public long queryCount(String index, String type, String whereCondition) {
        ESQuery esQuery = ESQuery.create((RestHighLevelClient)this.client, (String)index, (String)type);
        return esQuery.queryCount(whereCondition);
    }

    @Override
    public void setMaxWindow(String index, int maxwindow) {
        UpdateSettingsRequest request = new UpdateSettingsRequest(new String[]{index});
        request.settings(Settings.builder().put("max_result_window", maxwindow));
        try {
            this.client.indices().putSettings(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new KDException(DtsErrorCode.ioError, new Object[0]);
        }
    }

    private Object toLowerCawe(Object value, String entityNumber) {
        if (this.region == null || !"quicksearch".equals(this.region.toLowerCase(Locale.ENGLISH))) {
            return value;
        }
        boolean ignoreCase = ORMUtil.isIgnoreCase((String)entityNumber, (boolean)true);
        if (ignoreCase && value instanceof String) {
            return ((String)value).toLowerCase(Locale.ENGLISH);
        }
        return value;
    }
}

