/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.impl.fulltext.mapping;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.RowInfo;
import kd.bos.dts.impl.fulltext.Mapper;
import kd.bos.dts.impl.fulltext.access.ESAccess;
import kd.bos.dts.multientity.MultiEntity;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class ESDefaultMapper
implements Mapper {
    private String region;

    public ESDefaultMapper() {
    }

    public ESDefaultMapper(String region) {
        this.region = region;
    }

    public Map<?, ?> convert2Es(String tableName, RowInfo row) {
        Map dataMap = row.getData();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("entityname", DataSyncConfigCache.get().getEntityNumberByTableName(row.getTable()));
        dataMap.forEach((k, v) -> result.put((String)k, (String)v));
        return result;
    }

    public String getKeyId(RowInfo row) {
        return String.valueOf(row.getKey());
    }

    public boolean checkTable(String tableName) {
        return true;
    }

    public String getFieldStoredName(String tableName, String filed) {
        return filed;
    }

    public String getIndexName(String table) {
        return "es_dts_" + table;
    }

    public String getESDataType() {
        return "doc";
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public List<RowInfo> preHandle(List<RowInfo> rowInfos) {
        return rowInfos;
    }

    public void deleteEntity(String entityNumber) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"entityname", (String)entityNumber));
        String tableName = DtsUtils.getTableNameByEntityNumber(entityNumber);
        ESAccess.get(this.region).deleteByQuery(this.getIndexName(tableName), this.getESDataType(), (QueryBuilder)boolQueryBuilder);
        ESAccess.get(this.region).deleteByQuery(this.getIndexName(tableName + "_l"), this.getESDataType(), (QueryBuilder)boolQueryBuilder);
    }

    public MultiEntity getMultiEntity() {
        return new MultiEntity(){

            public String getMainEntityNumber(String arg0) {
                return arg0;
            }

            public boolean isMainEntity(String arg0) {
                return true;
            }
        };
    }
}

