/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.impl.fulltext.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.impl.NotifyCache;
import kd.bos.dts.impl.fulltext.access.ESAccess;
import kd.bos.dts.impl.fulltext.mapping.ESFullTextMapper;
import kd.bos.dts.impl.fulltext.mapping.FieldMeta;
import kd.bos.dts.impl.fulltext.mapping.TableMeta;
import kd.bos.fulltext.common.util.CommonUtil;

public class EsConfigMonitor {
    private static Map<String, EsConfigMonitor> instances = new ConcurrentHashMap<String, EsConfigMonitor>(2);
    private static final String PY = "py";
    private static final String FULLTEXT_INDEX_TYPE = "t_monitor";
    private static final String[] TMONITORFIELDS = new String[]{"fpropertyName", "entityName", "tableName", "fieldName", "flang", "fdataType"};
    private Map<String, Map<String, TableMeta>> tablesMap;
    private String region;

    public static EsConfigMonitor get(String region) {
        return instances.computeIfAbsent(region + RequestContext.get().getAccountId(), key -> new EsConfigMonitor(region));
    }

    EsConfigMonitor(String region) {
        this.region = region;
    }

    private String getMonitorIndexName() {
        return CommonUtil.getIndexNamePrefix((String)this.region) + "_monitor";
    }

    public void init() {
        if (this.tablesMap == null || !NotifyCache.get().contains("fulltext_metaconfig_needRefresh")) {
            this.tablesMap = this._init();
        }
    }

    private Map<String, Map<String, TableMeta>> _init() {
        try {
            ArrayList<Map<String, String>> configures = new ArrayList<Map<String, String>>();
            int batchSize = 1000;
            String lastSearchAfter = null;
            for (int i = 0; i < batchSize; ++i) {
                List<Map<String, String>> configures_step = null;
                configures_step = ESAccess.get(this.region).querySearchAfter(this.getMonitorIndexName(), FULLTEXT_INDEX_TYPE, TMONITORFIELDS, null, lastSearchAfter, batchSize);
                if (!configures_step.isEmpty()) {
                    lastSearchAfter = configures_step.get(configures_step.size() - 1).get("_id");
                }
                if (configures_step.isEmpty()) break;
                configures.addAll(configures_step);
                if (configures_step.size() < batchSize) break;
            }
            HashMap<String, Map<String, TableMeta>> tableMetas = new HashMap<String, Map<String, TableMeta>>();
            for (Map map : configures) {
                FieldMeta f;
                TableMeta tm;
                Map entityTableMap;
                String _tableName;
                Map entityTableMeta;
                TableMeta table;
                FieldMeta fm;
                String propertyName = (String)map.get("fpropertyName");
                String entityName = (String)map.get("entityName");
                String _tmpTabName = (String)map.get("tableName");
                if (_tmpTabName == null) continue;
                String orignTableName = _tmpTabName.toLowerCase();
                String filedName = map.get("fieldName") == null || "null".equals(map.get("fieldName")) ? "" : ((String)map.get("fieldName")).toLowerCase();
                String flang = (String)map.get("flang");
                String dataType = (String)map.get("fdataType");
                boolean isPy = PY.equals(flang);
                boolean isMultLnag = flang != null && flang.trim().length() != 0 && !isPy;
                String tableName = orignTableName;
                if (isMultLnag) {
                    tableName = orignTableName + "_l";
                }
                if ((fm = (table = (entityTableMeta = tableMetas.computeIfAbsent(_tableName = tableName, k -> new HashMap(2))).computeIfAbsent(entityName, k -> {
                    TableMeta tableM = new TableMeta(_tableName, isMultLnag);
                    tableM.setEntityName(entityName);
                    return tableM;
                })).getField(filedName)) == null) {
                    fm = new FieldMeta();
                    fm.setPropertyName(propertyName);
                    fm.setFiledName(filedName);
                    fm.setDatatype(dataType);
                    table.addField(fm);
                }
                if (isMultLnag) {
                    fm.addLangStr(flang);
                    entityTableMap = (Map)tableMetas.get(orignTableName);
                    if (entityTableMap != null && (tm = (TableMeta)entityTableMap.get(entityName)) != null && (f = tm.getField(filedName)) != null && f.isPy()) {
                        fm.setPy(true);
                    }
                } else if (isPy && (entityTableMap = (Map)tableMetas.get(orignTableName + "_l")) != null && (tm = (TableMeta)entityTableMap.get(entityName)) != null && (f = tm.getField(filedName)) != null) {
                    f.setPy(true);
                }
                fm.setPy(isPy);
            }
            NotifyCache.get().put("fulltext_metaconfig_needRefresh", "fulltext_metaconfig_needRefresh");
            return tableMetas;
        }
        catch (Throwable e) {
            ExceptionLogger.error(ESFullTextMapper.class, (String)"EsSyncFullTextMapping init error:", (Throwable)e);
            return new HashMap<String, Map<String, TableMeta>>();
        }
    }

    public TableMeta getTableMeta(String tableName, String entityName) {
        return this.tablesMap.get(tableName).get(entityName);
    }

    public Map<String, TableMeta> getTableMetaMap(String tableName) {
        return this.tablesMap.get(tableName);
    }

    public TableMeta getTableMeta(String tableName) {
        return this.tablesMap.get(tableName).values().iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTable(String tableName) {
        if (!NotifyCache.get().contains("fulltext_metaconfig_needRefresh")) {
            EsConfigMonitor esConfigMonitor = this;
            synchronized (esConfigMonitor) {
                if (!NotifyCache.get().contains("fulltext_metaconfig_needRefresh")) {
                    this.init();
                }
            }
        }
        return this.tablesMap.containsKey(tableName);
    }

    public Set<String> getEntityNames(String tableName) {
        Map<String, TableMeta> entityMetas = this.tablesMap.get(tableName);
        if (entityMetas != null) {
            return Collections.unmodifiableSet(entityMetas.keySet());
        }
        return Collections.emptySet();
    }
}

