/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.impl.mongodb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.RowInfo;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.impl.mongodb.MongoUtils;
import kd.bos.dts.init.AbstractInitialize;
import kd.bos.dts.syncconfig.SyncConfigCompareInfo;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.exception.KDException;
import kd.bos.nosql.IndexableTableStorage;
import kd.bos.nosql.Row;
import kd.bos.nosql.StorageFactory;
import kd.bos.orm.datasync.DestinationTransRule;

public class MongoInitialize
extends AbstractInitialize {
    private IndexableTableStorage storage = StorageFactory.getIndexableSotrage();

    public MongoInitialize(DestinationTransRule destinationRule) {
        super(destinationRule);
    }

    @Override
    public void deleteEntity(SyncConfigInfo compare) {
        String entityNumber = compare.getEntitynumber();
        String table = DtsUtils.getTableNameByEntityNumber(entityNumber);
        DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(entityNumber);
        AtomicBoolean hasMultiFiled = new AtomicBoolean(false);
        ArrayList other = new ArrayList();
        entityType.getProperties().forEach(v -> {
            if (!(v instanceof DynamicCollectionProperty)) {
                try {
                    if (!Class.forName("kd.bos.entity.property.MuliLangTextProp").isAssignableFrom(v.getClass())) return;
                    hasMultiFiled.set(true);
                    return;
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, DtsErrorCode.dtserror, new Object[]{"MuliLangTextProp not found"});
                }
            } else {
                other.add(v);
            }
        });
        this.storage.drop(table);
        if (hasMultiFiled.get()) {
            this.storage.drop(table + "_l");
        }
        other.forEach(v -> {
            try {
                String entryTable;
                if (Class.forName("kd.bos.entity.property.EntryProp").isAssignableFrom(v.getClass()) && (entryTable = ((DynamicCollectionProperty)v).getItemType().getAlias()) != null) {
                    this.storage.drop(entryTable.toLowerCase());
                    HashSet splitTable_suff = new HashSet();
                    ((DynamicCollectionProperty)v).getItemType().getProperties().forEach(property -> splitTable_suff.add(property.getTableGroup()));
                    splitTable_suff.forEach(suff -> this.storage.drop(entryTable.toLowerCase() + "_" + suff));
                }
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, DtsErrorCode.dtserror, new Object[]{"EntryProp not found"});
            }
        });
    }

    @Override
    protected int getBatchSize() {
        return Integer.getInteger("dts.mongo.init.querybatchsize", 5000);
    }

    @Override
    public void doTransmitData(List<RowInfo> esconsumers) {
        this.store(esconsumers);
    }

    private void store(List<RowInfo> esconsumers) {
        String table = esconsumers.get(0).getTable();
        List rows = esconsumers.stream().map(r -> {
            Row row = Row.of((Map)r.getData());
            row.add("_id", (Object)MongoUtils.getRowKey(table, String.valueOf(r.getKey()), row));
            return row;
        }).collect(Collectors.toList());
        this.storage.add(table, rows.iterator());
    }

    @Override
    protected void deleteEntityFileds(SyncConfigCompareInfo compare, String deleteFileds) {
    }
}

