/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.impl.mongodb;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dts.AbstractOutput;
import kd.bos.dts.RowInfo;
import kd.bos.dts.impl.mongodb.MongoUtils;
import kd.bos.lang.Lang;
import kd.bos.nosql.IndexableTableStorage;
import kd.bos.nosql.Row;
import kd.bos.nosql.StorageFactory;
import kd.bos.orm.datasync.DestinationTransRule;

public class MongoOutput
extends AbstractOutput {
    private IndexableTableStorage storage = StorageFactory.getIndexableSotrage();

    public MongoOutput(DestinationTransRule destinationRule) {
        super(destinationRule);
    }

    @Override
    public void deleteTrans(List<RowInfo> esconsumers) {
        String table = esconsumers.get(0).getTable();
        StringBuilder filter = new StringBuilder();
        StringBuilder multiLangfilter = new StringBuilder();
        esconsumers.forEach(v -> {
            filter.append("'").append(v.getKey()).append("',");
            for (Lang lang : Lang.values()) {
                multiLangfilter.append("'").append(v.getKey()).append(lang).append("',");
            }
        });
        this.storage.delete(table, "_id in ({{ids}})".replaceAll("\\{\\{ids\\}\\}", filter.deleteCharAt(filter.length() - 1).toString()));
        this.storage.delete(table + "_l", "_id in ({{ids}})".replaceAll("\\{\\{ids\\}\\}", multiLangfilter.deleteCharAt(multiLangfilter.length() - 1).toString()));
    }

    @Override
    public void insertTrans(List<RowInfo> esconsumers) {
        String table = esconsumers.get(0).getTable();
        List rows = esconsumers.stream().map(r -> {
            Row row = Row.of((Map)r.getData());
            row.add("_id", (Object)MongoUtils.getRowKey(table, String.valueOf(r.getKey()), row));
            return row;
        }).collect(Collectors.toList());
        this.storage.add(table, rows.iterator());
    }

    @Override
    public void updateTrans(List<RowInfo> esconsumers) {
        String table = esconsumers.get(0).getTable();
        List rows = esconsumers.stream().map(r -> {
            Row row = Row.of((Map)r.getData());
            row.add("_id", (Object)MongoUtils.getRowKey(table, String.valueOf(r.getKey()), row));
            return row;
        }).collect(Collectors.toList());
        this.storage.store(table, rows.iterator());
    }

    @Override
    public void ddlTrans(String ddl) {
    }
}

