/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dts.RowInfo;
import kd.bos.dts.init.Initialize;
import kd.bos.dts.init.QueryAndImport;
import kd.bos.dts.syncconfig.SyncConfigCompareInfo;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.orm.datasync.DestinationTransRule;

public abstract class AbstractInitialize
implements Initialize {
    private DestinationTransRule destinationRule;
    protected String region;

    public AbstractInitialize(DestinationTransRule destinationRule) {
        this.destinationRule = destinationRule;
        String region = destinationRule.getRegion();
        if (region == null || region.length() == 0) {
            region = "quicksearch";
        }
        this.region = region;
    }

    @Override
    public void initCreateEntityMeta(SyncConfigInfo scinfo) {
    }

    protected abstract int getBatchSize();

    @Override
    public final void updateEntity(SyncConfigCompareInfo compare) {
        if (compare.isAllFields() || compare.isNewAllFields()) {
            this.deleteEntity(compare);
            compare.setConfiggedEntityfields(compare.getConfiggedNewEntityFileds());
            this.initCreateEntityMeta(compare);
            this.initImportEntityData(compare);
        } else {
            HashSet<String> oldFields = new HashSet<String>(4);
            HashSet<String> newFields = new HashSet<String>(4);
            for (String filed : compare.getConfiggedEntityfields().split(",")) {
                oldFields.add(filed);
            }
            for (String filed : compare.getConfiggedNewEntityFileds().split(",")) {
                newFields.add(filed);
            }
            HashSet addedSet = new HashSet(newFields);
            addedSet.removeAll(oldFields);
            HashSet deletedSet = new HashSet(oldFields);
            deletedSet.removeAll(newFields);
            String deleteFileds = deletedSet.stream().collect(Collectors.joining(","));
            String addFileds = addedSet.stream().collect(Collectors.joining(","));
            if (deleteFileds.length() > 0) {
                this.deleteEntityFileds(compare, deleteFileds);
            }
            if (addFileds.length() > 0) {
                SyncConfigCompareInfo compareAdded = new SyncConfigCompareInfo(compare);
                compareAdded.setConfiggedEntityfields(addFileds);
                this.initCreateEntityMeta(compareAdded);
                this.initImportEntityData(compareAdded);
                String dynFields = compareAdded.getDynEntityfields();
                if (dynFields != null && dynFields.length() > 0) {
                    for (String dynField : dynFields.split(",")) {
                        compare.addDynFiled(dynField);
                    }
                }
            }
        }
    }

    protected abstract void deleteEntityFileds(SyncConfigCompareInfo var1, String var2);

    @Override
    public final void initImportEntityData(SyncConfigInfo scinfo) {
        Consumer consumer = (Consumer<List> & Serializable)data -> this.doTransmitData((List<RowInfo>)data);
        QueryAndImport.get().initImportData(this.destinationRule, scinfo, this.getBatchSize(), consumer);
    }

    public abstract void doTransmitData(List<RowInfo> var1);
}

