/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.configoperator.DtsConfigOperatorInfo;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.init.AddressStatus;
import kd.bos.dts.syncconfig.SyncConfigCompareInfo;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.ConfigureItemStatus;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DtsPower;
import kd.bos.orm.datasync.DtsThreadContext;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import org.apache.commons.lang.StringUtils;

public class DtsSnapConfigDao {
    public static final DtsSnapConfigDao instance = new DtsSnapConfigDao();
    private static final Log log = LogFactory.getLog(DtsSnapConfigDao.class);
    public static final String DEFAULT_MAPPINGRULE = " ";
    private static final String ALGO_KEY_DTS = "dtsRunCompareTask";

    public void update(SyncConfigCompareInfo compare) {
        try (TXHandle tx = TX.requiresNew();
             DtsThreadContext dtsContext = DtsThreadContext.create();){
            List<SyncConfigCompareInfo> compareList = instance.getDtsConfigChanged(compare.getEntitynumber(), compare.getDestinationtype(), compare.getRegion(), compare.getMappingrule());
            if (compareList.size() == 1) {
                compare = compareList.get(0);
                if (OperationType.INSERT == compare.getOperationStates()) {
                    this.insertSnapshot(compare);
                    this.updateStatus(compare, ConfigureItemStatus.working);
                } else if (OperationType.UPDATE == compare.getOperationStates()) {
                    this.updateSnapshot(compare);
                    this.updateStatus(compare, ConfigureItemStatus.working);
                } else if (OperationType.DELETE == compare.getOperationStates()) {
                    this.deleteSnapshot(compare);
                    this.updateStatus(compare, ConfigureItemStatus.stopped);
                    this.updateTables(compare);
                }
            }
        }
    }

    private void deleteSnapshot(SyncConfigCompareInfo compare) {
        String sql = "delete from  t_dts_syncconfigsnapshot where fid = ?";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{compare.getFid()});
    }

    private void updateSnapshot(SyncConfigCompareInfo compare) {
        String sql = "update  t_dts_syncconfigsnapshot set fentitynumber=? ,fentityfields=? ,fdestinationtype=? ,fregion=? ,fmappingrule=? ,ftimingsequence=? where fid = ?";
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{compare.getEntitynumber(), compare.getConfiggedNewEntityFileds(), compare.getDestinationtype(), compare.getRegion(), compare.getMappingrule(), compare.getTimingSequenceField(), compare.getFid()});
    }

    private void insertSnapshot(SyncConfigCompareInfo compare) {
        String sql = "insert into  t_dts_syncconfigsnapshot(fenable,fentitynumber,fentityfields,fdestinationtype,fregion,fmappingrule,ftimingsequence,fbusinesstype,fid) values(?,?,?,?,?,?,?,?,?)";
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{"1", compare.getEntitynumber(), compare.getConfiggedEntityfields(), compare.getDestinationtype(), compare.getRegion(), compare.getMappingrule(), compare.getTimingSequenceField(), compare.getBusinessType(), compare.getFid()});
    }

    public void updateStatus(SyncConfigCompareInfo compare, ConfigureItemStatus stauts) {
        try (TXHandle h = TX.requiresNew();
             DtsThreadContext dtsContext = DtsThreadContext.create();){
            String sql = "update  t_dts_datasyncconfig set fstatus=?  where fid = ?";
            DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{stauts, compare.getFid()});
            DataSyncConfigCache.get().removeCache();
        }
    }

    private void updateTables(SyncConfigCompareInfo compare) {
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)"update t_dts_datasyncconfig set ftables=? where fentitynumber=?", (Object[])new Object[]{DEFAULT_MAPPINGRULE, compare.getEntitynumber()});
        }
        catch (Throwable e) {
            log.error("dtserror:updateTables", e);
        }
    }

    public SyncConfigInfo getConfigInfo(long fid) {
        StringBuilder sql = new StringBuilder(" select fid,fentitynumber,fentityfields,fdestinationtype,");
        sql.append(" fregion,fmappingrule,ftimingsequence,fbusinesstype,fstatus ");
        sql.append(" from t_dts_datasyncconfig ");
        sql.append(" where fid = ? ");
        try (DataSet ds = DB.queryDataSet((String)"getConfigInfo", (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])new Object[]{fid});){
            SyncConfigInfo scinfo = null;
            if (ds.hasNext()) {
                Row v = ds.next();
                scinfo = new SyncConfigInfo();
                String bussinesstype = v.getString("fbusinesstype");
                scinfo.setFid(v.getLong("fid"));
                scinfo.setDestinationtype(v.getString("fdestinationtype"));
                scinfo.setConfiggedEntityfields(v.getString("fentityfields"));
                scinfo.setEntitynumber(v.getString("fentitynumber"));
                scinfo.setMappingrule(v.getString("fmappingrule"));
                String _region = v.getString("fregion");
                scinfo.setRegion(this.parseRegion(_region));
                scinfo.setTimingSequenceField(v.getString("ftimingsequence"));
                scinfo.setBusinessType(bussinesstype);
                scinfo.setStatus(v.getString("fstatus"));
            }
            SyncConfigInfo syncConfigInfo = scinfo;
            return syncConfigInfo;
        }
    }

    public Map<String, SyncConfigInfo> getConfigItems() {
        Map<String, SyncConfigInfo> syncConfigMap = this.getConfigInfo(new HashMap<String, SyncConfigInfo>(), "t_dts_datasyncconfig", null, null, null, null);
        return syncConfigMap;
    }

    public Map<String, SyncConfigInfo> getConfigItem(String entityNumber) {
        Map<String, SyncConfigInfo> syncConfigMap = this.getConfigInfo(new HashMap<String, SyncConfigInfo>(), "t_dts_datasyncconfig", entityNumber, null, null, null);
        return syncConfigMap;
    }

    private Map<String, SyncConfigInfo> getConfigInfo(HashMap<String, SyncConfigInfo> configMap, String tableName, String entityNumber, String destType, String region, String mappingRule) {
        StringBuilder sql = new StringBuilder("select fid,fentitynumber,fentityfields,fdestinationtype,fregion,fmappingrule,ftimingsequence,fbusinesstype,fstatus from ");
        sql.append(tableName);
        sql.append(" where fenable='1' ");
        if (entityNumber != null || destType != null || region != null) {
            sql.append(" and ");
            if (entityNumber != null) {
                sql.append(" fentitynumber='").append(entityNumber).append("' ");
            }
            if (destType != null) {
                sql.append(" and ");
                sql.append(" fdestinationtype='").append(destType).append("' ");
            }
            if (mappingRule != null) {
                if ("".equals(mappingRule.trim())) {
                    mappingRule = DEFAULT_MAPPINGRULE;
                }
                sql.append(" and ");
                sql.append(" fmappingrule ='").append(mappingRule).append("' ");
            }
            if (region != null) {
                sql.append(" and ");
                sql.append(" fregion like '%").append(region).append("%' ");
            }
        }
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY_DTS, (DBRoute)DBRoute.basedata, (String)sql.toString());){
            ds.forEach(v -> {
                String bussinesstype = v.getString("fbusinesstype");
                if (!DtsPower.isBusinessTypeEnable((String)bussinesstype)) {
                    return;
                }
                SyncConfigInfo scinfo = new SyncConfigInfo();
                scinfo.setFid(v.getLong("fid"));
                scinfo.setDestinationtype(v.getString("fdestinationtype"));
                scinfo.setConfiggedEntityfields(v.getString("fentityfields"));
                scinfo.setEntitynumber(v.getString("fentitynumber"));
                scinfo.setMappingrule(v.getString("fmappingrule"));
                String _region = v.getString("fregion");
                scinfo.setRegion(this.parseRegion(_region));
                scinfo.setTimingSequenceField(v.getString("ftimingsequence"));
                scinfo.setBusinessType(bussinesstype);
                scinfo.setStatus(v.getString("fstatus"));
                configMap.put(DtsUtils.getEntitySplitKey(scinfo.getEntitynumber(), scinfo.getDestinationtype(), scinfo.getRegion(), scinfo.getMappingrule()), scinfo);
            });
        }
        return configMap;
    }

    public List<SyncConfigCompareInfo> getDtsConfigChanged() {
        return this.getDtsConfigChanged(null, null, null, null);
    }

    public List<SyncConfigCompareInfo> getDtsConfigChanged(String entityNumber, String destType, String region, String mappingRule) {
        Map<String, SyncConfigInfo> syncConfigMap = this.getConfigInfo(new HashMap<String, SyncConfigInfo>(), "t_dts_datasyncconfig", entityNumber, destType, region, mappingRule);
        Map<String, SyncConfigInfo> syncConfigMapSnapshot = this.getConfigInfo(new HashMap<String, SyncConfigInfo>(), "t_dts_syncconfigsnapshot", entityNumber, destType, region, mappingRule);
        ArrayList<SyncConfigCompareInfo> compareList = new ArrayList<SyncConfigCompareInfo>();
        syncConfigMap.forEach((k, v) -> {
            if (syncConfigMapSnapshot.containsKey(k)) {
                SyncConfigInfo snapshot = (SyncConfigInfo)syncConfigMapSnapshot.get(k);
                if (!snapshot.getConfiggedEntityfields().equals(v.getConfiggedEntityfields())) {
                    SyncConfigCompareInfo scci = new SyncConfigCompareInfo(snapshot);
                    scci.setOperationStates(OperationType.UPDATE);
                    scci.setConfiggedNewEntityFileds(v.getConfiggedEntityfields());
                    scci.setBusinessType(v.getBusinessType());
                    compareList.add(scci);
                }
            } else {
                SyncConfigCompareInfo scci = new SyncConfigCompareInfo((SyncConfigInfo)v);
                scci.setOperationStates(OperationType.INSERT);
                compareList.add(scci);
            }
        });
        syncConfigMapSnapshot.forEach((k, v) -> {
            if (!syncConfigMap.containsKey(k)) {
                SyncConfigCompareInfo scci = new SyncConfigCompareInfo((SyncConfigInfo)v);
                scci.setOperationStates(OperationType.DELETE);
                compareList.add(scci);
            }
        });
        return compareList;
    }

    public List<AddressStatus> getDestinationInfo() {
        ArrayList<AddressStatus> configList = new ArrayList<AddressStatus>();
        StringBuilder sql = new StringBuilder("select distinct fdestinationtype,fregion,fstatus from t_dts_datasyncconfig ");
        sql.append(" where fenable='1' ");
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY_DTS, (DBRoute)DBRoute.basedata, (String)sql.toString());){
            ds.forEach(v -> {
                String _region = v.getString("fregion");
                AddressStatus as = new AddressStatus();
                as.setDestinationtype(v.getString("fdestinationtype"));
                as.setRegion(this.parseRegion(_region));
                as.setStatus(v.getString("fstatus"));
                configList.add(as);
            });
        }
        return configList;
    }

    public List<AddressStatus> getDestinationInfoForWork() {
        ArrayList<AddressStatus> configList = new ArrayList<AddressStatus>();
        StringBuilder sql = new StringBuilder("select distinct fdestinationtype,fregion,fstatus from t_dts_datasyncconfig ");
        sql.append(" where fenable='1' and fstatus in ('working','suspend')");
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY_DTS, (DBRoute)DBRoute.basedata, (String)sql.toString());){
            ds.forEach(v -> {
                String _region = v.getString("fregion");
                AddressStatus as = new AddressStatus();
                as.setDestinationtype(v.getString("fdestinationtype"));
                as.setRegion(this.parseRegion(_region));
                as.setStatus(v.getString("fstatus"));
                configList.add(as);
            });
        }
        return configList;
    }

    public Set<String> getEntityNumberSet() {
        HashSet<String> numberSet = new HashSet<String>(10);
        StringBuilder sql = new StringBuilder("select distinct fentitynumber from t_dts_datasyncconfig ");
        sql.append(" where fenable='1' ");
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY_DTS, (DBRoute)DBRoute.basedata, (String)sql.toString());){
            ds.forEach(v -> numberSet.add(v.getString("fentitynumber")));
        }
        return numberSet;
    }

    private String parseRegion(String region) {
        if (region == null) {
            return null;
        }
        String[] details = region.split(",");
        ArrayList<String> detailSet = new ArrayList<String>();
        for (String detail : details) {
            if (detail.trim().length() <= 0) continue;
            detailSet.add(detail.trim());
        }
        return detailSet.stream().collect(Collectors.joining(","));
    }

    public void suspend(String destype, String region) {
        this.suspendOrResume(true, destype, region, null);
    }

    public void resume(String destype, String region, List<Long> notResume) {
        if (notResume.isEmpty()) {
            this.suspendOrResume(false, destype, region, null);
        } else {
            StringBuilder querySql = new StringBuilder("select fentitynumber from t_dts_datasyncconfig where fstatus='suspend' and fdestinationtype= ?  and fregion like ? and fid not in (");
            ArrayList<String> params = new ArrayList<String>();
            params.add(destype);
            params.add("%" + region + "%");
            notResume.forEach(v -> {
                params.add((String)v);
                querySql.append("?,");
            });
            querySql.setLength(querySql.length() - 1);
            querySql.append(")");
            try (DataSet ds = DB.queryDataSet((String)ALGO_KEY_DTS, (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])params.toArray(new Object[0]));){
                ds.forEach(v -> {
                    String entityNumber = v.getString("fentitynumber");
                    this.suspendOrResume(false, destype, region, entityNumber);
                });
            }
        }
    }

    private void suspendOrResume(boolean isSuspend, String destype, String region, String entityNumber) {
        this.suspendOrResume(isSuspend, destype, region, entityNumber, false, null);
    }

    private void suspendOrResume(boolean isSuspend, String destype, String region, String entityNumber, boolean isMappingFliter, String mappingRule) {
        ArrayList<Object> params = new ArrayList<Object>();
        try (TXHandle h = TX.requiresNew();){
            StringBuilder sql = new StringBuilder("update  t_dts_datasyncconfig set fstatus= ?  where  fenable='1' and fstatus = ? and fdestinationtype= ? ");
            if (isMappingFliter) {
                sql.append(" and fmappingrule= ? ");
            }
            sql.append(" and fregion like ? ");
            if (entityNumber != null) {
                sql.append(" and fentitynumber= ? ");
            }
            if (isSuspend) {
                params.add(ConfigureItemStatus.suspend);
                params.add(ConfigureItemStatus.working);
            } else {
                params.add(ConfigureItemStatus.working);
                params.add(ConfigureItemStatus.suspend);
            }
            params.add(destype);
            if (isMappingFliter) {
                params.add(mappingRule);
            }
            params.add("%" + region + "%");
            if (entityNumber != null) {
                params.add(entityNumber);
            }
            DB.update((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params.toArray(new Object[0]));
            DataSyncConfigCache.get().removeCache();
        }
        ExceptionLogger.log(DtsSnapConfigDao.class, (String)((isSuspend ? "suspend dts " : "resume dts ") + "info: " + JSON.toJSON(params)));
    }

    public void suspendOnlineException(String entityNumber, DestinationTransRule destination) {
        String mappingRule = destination.getMappingrule();
        if ("".equals(mappingRule)) {
            mappingRule = DEFAULT_MAPPINGRULE;
        }
        this.suspendOrResume(true, destination.getType().getName(), destination.getRegion(), entityNumber, true, mappingRule);
    }

    public void resumeOnlineException(String entityNumber, DestinationTransRule destination) {
        String mappingRule = destination.getMappingrule();
        if ("".equals(mappingRule)) {
            mappingRule = DEFAULT_MAPPINGRULE;
        }
        this.suspendOrResume(false, destination.getType().getName(), destination.getRegion(), entityNumber, true, mappingRule);
    }

    public void insertDataSyncConfig(DtsConfigOperatorInfo info) {
        long id = IDService.get().genLongId();
        String mappingRule = info.getMappingRule();
        if (mappingRule == null || "".equals(mappingRule.trim())) {
            mappingRule = DEFAULT_MAPPINGRULE;
        }
        String entityFields = StringUtils.join((Object[])info.getEntityFields(), (String)",");
        String sql = "insert into t_dts_datasyncconfig(fentitynumber,fdestinationtype,fregion,fbusinesstype,fmappingrule,fentityfields,fenable,ftimingsequence,fid) values(?,?,?,?,?,?,?,?,?)";
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{info.getEntityNumber(), info.getDtsDestType().getCode(), info.getRegion(), info.getBusinessType(), mappingRule, entityFields, info.getEnable(), info.getTimingSequence(), id});
    }

    public void deleteDataSyncConfig(String entityNumber, String region, String businessType, String mappingRule, String destType) {
        if (mappingRule == null || "".equals(mappingRule.trim())) {
            mappingRule = DEFAULT_MAPPINGRULE;
        }
        String sql = "delete from t_dts_datasyncconfig where fentitynumber = ? and fregion = ? and fbusinesstype = ? and fmappingrule= ? and fdestinationtype= ? ";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{entityNumber, region, businessType, mappingRule, destType});
    }

    public void updateDataSyncConfigStatus(boolean enable, String entityNumber, String region, String businessType, String mappingRule, String destType) {
        if (mappingRule == null || "".equals(mappingRule.trim())) {
            mappingRule = DEFAULT_MAPPINGRULE;
        }
        String enableStr = enable ? "1" : "0";
        String sql = "update t_dts_datasyncconfig set fenable = ?  where fentitynumber = ? and fregion = ? and fbusinesstype = ? and fmappingrule= ? and fdestinationtype= ? ";
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{enableStr, entityNumber, region, businessType, mappingRule, destType});
    }

    public boolean existsSyncConfigSnapshot(String entityNumber, String region, String businessType, String mappingRule, String destType) {
        if (mappingRule == null || "".equals(mappingRule.trim())) {
            mappingRule = DEFAULT_MAPPINGRULE;
        }
        String sql = "select fentitynumber  from t_dts_syncconfigsnapshot where fentitynumber = ? and fregion = ? and fbusinesstype = ? and fmappingrule= ? and fdestinationtype= ? ";
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY_DTS, (DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{entityNumber, region, businessType, mappingRule, destType});){
            if (ds.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public void deleteDataSyncLog() {
        String sql = "truncate table t_dts_log ";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[0]);
    }
}

