/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dts.RowInfo;
import kd.bos.dts.init.AbstractRowGenerator;
import kd.bos.dts.init.PKWrapper;
import kd.bos.orm.datasync.OperationType;
import kd.bos.util.SafeLogUtils;

public class QueryGenRowMulitWithSqlQuery
extends AbstractRowGenerator {
    private static final long serialVersionUID = 3795985107894903164L;
    private List<Object> pkList = new ArrayList<Object>();
    private String tableName;
    private String routeKey;
    private Map<String, String> mulitfieldsMap;
    private PKWrapper pk;

    public QueryGenRowMulitWithSqlQuery(String tableName, DynamicObjectType entityType, Map<String, String> mulitfieldsMap, ISimpleProperty pk) {
        this.tableName = tableName + "_l";
        this.routeKey = entityType.getDBRouteKey();
        this.mulitfieldsMap = mulitfieldsMap;
        this.pk = new PKWrapper(pk);
    }

    @Override
    public String getName() {
        return "QueryGenRowMulitWithSqlQuery";
    }

    @Override
    public void gen(Row r, String[] fieldNames) {
        this.pkList.add(r.get(this.pk.getName()));
    }

    @Override
    public void consumDatas(Consumer<List<RowInfo>> consumer) {
        StringBuilder sb = new StringBuilder("select ");
        String pkAlias = this.pk.getAlias();
        this.mulitfieldsMap.forEach((fieldName, dbfieldName) -> {
            if (dbfieldName == null || dbfieldName.length() == 0) {
                SafeLogUtils.info(QueryGenRowMulitWithSqlQuery.class, (String)("dts error : " + fieldName + " has no dbfield of " + this.tableName));
            } else {
                sb.append((String)dbfieldName).append(",");
            }
        });
        sb.append(pkAlias).append(",");
        sb.append("flocaleid").append(",").append("fpkid");
        sb.append(" from ").append(this.tableName).append(" where ").append(pkAlias).append(" in (");
        for (int i = this.pkList.size() - 1; i >= 0; --i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        try (DataSet ds = DB.queryDataSet((String)("QueryGenRowMulitWithSqlQuery_" + this.tableName), (DBRoute)DBRoute.of((String)this.routeKey), (String)sb.toString(), (Object[])this.pkList.toArray());){
            int batchSize = this.getBatchSize() * 10;
            ArrayList<RowInfo> consumrDatas = new ArrayList<RowInfo>(4);
            while (ds.hasNext()) {
                Row r = ds.next();
                RowInfo ri = new RowInfo();
                ri.setType(OperationType.INSERT.getName());
                ri.setTable(this.tableName);
                ri.setKey(r.get(pkAlias));
                this.mulitfieldsMap.forEach((fieldName, dbfieldName) -> ri.getData().put(dbfieldName.toLowerCase(), r.get(dbfieldName)));
                ri.getData().put("flocaleid", r.get("flocaleid"));
                ri.getData().put("fpkid", r.get("fpkid"));
                ri.getData().put(pkAlias, r.get(pkAlias));
                consumrDatas.add(ri);
                if (consumrDatas.size() <= batchSize) continue;
                consumer.accept(consumrDatas);
                consumrDatas.clear();
            }
            if (!consumrDatas.isEmpty()) {
                consumer.accept(consumrDatas);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.pkList.clear();
    }
}

