/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init.async;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.dts.DtsMsgSender;
import kd.bos.dts.RowInfo;
import kd.bos.dts.init.AbstractInitialize;
import kd.bos.dts.init.AbstractRowGenerator;
import kd.bos.dts.init.InitializeFactory;
import kd.bos.orm.datasync.DestinationTransRule;

public class AsyncInitializeImport {
    public static final String ROWGENERATORS = "rowGenerators";
    public static final String BATCHID = "batchId";
    public static final String DESTINATIONTYPE = "consumers";
    public static final String ENTITYKEY = "entityKey";
    public static final String BATCHCOUNT = "batchCount";

    public static AsyncInitializeImport get() {
        return Handler.instance;
    }

    public void send(String batchId, List<AbstractRowGenerator> rowGenerators, DestinationTransRule destination, String entityKey, int batchCount) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(BATCHID, batchId);
        m.put(ROWGENERATORS, rowGenerators);
        m.put(DESTINATIONTYPE, destination);
        m.put(ENTITYKEY, entityKey);
        m.put(BATCHCOUNT, batchCount);
        DtsMsgSender.send("dts", "kd.bos.service.dts.async_initialize_import_queue", m);
    }

    public void apply(List<AbstractRowGenerator> rowGenerators, DestinationTransRule ruleType, String entityKey, int batchCount) {
        AbstractInitialize initializer = (AbstractInitialize)InitializeFactory.getInitializer(ruleType);
        Consumer consumer = (Consumer<List> & Serializable)data -> initializer.doTransmitData((List<RowInfo>)data);
        rowGenerators.forEach(v -> {
            v.consumDatas(consumer);
            v.clear();
        });
    }

    private static class Handler {
        private static final AsyncInitializeImport instance = new AsyncInitializeImport();

        private Handler() {
        }
    }
}

