/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.ksql;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.ksql.DtsStmtFactory;
import kd.bos.dts.ksql.stmt.DtsStmtHandler;
import kd.bos.ksql.TransInner;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.orm.datasync.DtsThreadContext;

public class DtsSqlHandler {
    private static final Set<Integer> unprocessedSql = new ConcurrentSkipListSet<Integer>();
    private static final Set<Integer> unLoggedSql = new ConcurrentSkipListSet<Integer>();
    private static final String PRE_SQL = "INSERT INTO T_DTS_KSQL_LOG(FID,FSQL,FLOGTIME) VALUES(?,?,?);";

    public static void handle(String ksql, Object ... params) throws Exception {
        if (DtsSqlHandler.needSync() && DtsAccountPower.isAccountDtsEnable()) {
            try {
                List ksqlStmts;
                if (RequestContext.get() == null || DtsSqlHandler.isExculde(ksql)) {
                    return;
                }
                try {
                    ksqlStmts = TransInner.parseStatement((String)ksql);
                }
                catch (Throwable e) {
                    DtsSqlHandler.recordKsql(ksql);
                    return;
                }
                SqlStmt sqlStmt = (SqlStmt)ksqlStmts.get(0);
                DtsStmtHandler handler = DtsStmtFactory.getDtsStmtParse(sqlStmt);
                handler.parse(sqlStmt, ksql, params);
            }
            catch (Exception e) {
                ExceptionLogger.log(DtsSqlHandler.class, (String)("DtsSqlHandler sql analysis error,source sql is:\u3010" + ksql + "\u3011"), (Throwable)e);
            }
        }
    }

    private static boolean needSync() {
        return !DtsExcludeSyncContext.isExclude() && !DtsThreadContext.isOrmSql();
    }

    private static boolean isExculde(String ksql) {
        return ksql.indexOf("CREATE PROCEDURE KSQL_TEMP_PROCEDURE") > 0;
    }

    public static void recordKsql(String sql) {
        if (DtsSqlHandler.isValide(sql = sql.toUpperCase(), "INSERT ") || DtsSqlHandler.isValide(sql, "UPDATE ") || DtsSqlHandler.isValide(sql, "DELETE ")) {
            int hashCode = sql.hashCode();
            if (unLoggedSql.add(hashCode)) {
                ExceptionLogger.log(DtsSqlHandler.class, (String)("DtsSqlHandler recordsql notsupported,sql:\u3010" + sql + "\u3011"));
            }
            if (DtsUtils.isKsqlLog() && unprocessedSql.add(hashCode)) {
                long id = DB.genGlobalLongId();
                try (TXHandle h = TX.requiresNew((String)"bos_dts_sql_log");){
                    DB.execute((DBRoute)DBRoute.base, (String)PRE_SQL, (Object[])new Object[]{id, sql, new Date(System.currentTimeMillis())});
                }
                catch (Throwable e) {
                    ExceptionLogger.log(DtsSqlHandler.class, (String)("DtsSqlHandler record sql error,sql:\u3010" + sql + "\u3011"), (Throwable)e);
                }
            }
        }
    }

    private static boolean isValide(String sql, String string) {
        int index = sql.indexOf(string);
        if (index == 0) {
            return true;
        }
        if (index > 0) {
            char c = sql.charAt(index - 1);
            return ('A' > c || c > 'Z') && ('0' > c || c > '9');
        }
        return false;
    }
}

