/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.ksql.stmt;

import kd.bos.db.DBRoute;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.ksql.DataDDLSyncValue;
import kd.bos.dts.ksql.stmt.AbstractDtsStmtHandler;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.DataSyncAgent;

public class DtsAlterTableStmtHandler
extends AbstractDtsStmtHandler {
    @Override
    public void parse(SqlStmt sqlStmt, String ksql, Object ... params) throws Exception {
        SqlAlterTableStmt sqlAlterTableStmt = (SqlAlterTableStmt)sqlStmt;
        String tableName = sqlAlterTableStmt.tableName;
        String sourceTableName = this.getOriginalName(tableName);
        DestinationTransRule[] transRules = this.syncConfig.getTransRuleByTableName(sourceTableName);
        if (transRules != null && transRules.length > 0) {
            String entityNumber = this.syncConfig.getEntityNumberByTableName(sourceTableName);
            DataDDLSyncValue ddl = new DataDDLSyncValue(tableName, entityNumber, ksql, false);
            String routeKey = DtsUtils.getDBRoutKeyByEntityNumber(entityNumber);
            DBRoute route = DBRoute.of((String)routeKey);
            ddl.setSourceSql(ksql);
            ddl.setSourceParams(params);
            DataSyncAgent.get().send(route, OperationType.DDL, (DataSyncValue)ddl);
        }
    }
}

