/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.ksql.stmt;

import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.ksql.DataSqlDeleteSyncValue;
import kd.bos.dts.ksql.stmt.AbstractDtsStmtHandler;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.stmt.SqlDeleteStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.DataSyncAgent;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;

public class DtsDeleteStmtHandler
extends AbstractDtsStmtHandler {
    @Override
    public void parse(SqlStmt sqlStmt, String ksql, Object ... params) {
        SqlDeleteStmt deleteStmt = (SqlDeleteStmt)sqlStmt;
        String tableName = deleteStmt.delete.tableName;
        String string = tableName = tableName != null ? tableName : ((SqlTableSource)deleteStmt.delete.tableSource).name;
        if (!this.checkTable(tableName)) {
            return;
        }
        String sourceTableName = this.getOriginalName(tableName);
        SqlExpr whereCondition = deleteStmt.delete.condition;
        DestinationTransRule[] transRules = this.syncConfig.getTransRuleByTableName(sourceTableName);
        if (transRules != null && transRules.length > 0) {
            String entityNumber = this.syncConfig.getEntityNumberByTableName(sourceTableName);
            String routeKey = DtsUtils.getDBRoutKeyByEntityNumber(entityNumber);
            DBRoute route = DBRoute.of((String)routeKey);
            String pkField = DataSyncConfigCache.get().getPrimaryField(entityNumber, sourceTableName);
            StringBuilder queryIds = new StringBuilder();
            queryIds.append("select ").append(pkField).append(" from ").append(tableName).append(" where ").append(whereCondition);
            DataSqlDeleteSyncValue delete = new DataSqlDeleteSyncValue(tableName, entityNumber, pkField, false);
            delete.setRouteKey(routeKey);
            try (TXHandle h = TX.requiresNew();){
                try (DataSet ds = DB.queryDataSet((String)"ESSqlOutputgetIDs", (DBRoute)route, (String)queryIds.toString(), (Object[])params);){
                    ds.forEach(v -> delete.addId(v.get(pkField)));
                }
                catch (Throwable e) {
                    ExceptionLogger.log(DtsDeleteStmtHandler.class, (String)String.format("DtsSqlHandler query delete`s ids error,sql:%s, ksql:%s", queryIds, ksql), (Throwable)e);
                }
            }
            delete.setQueryIdSql(queryIds.toString());
            delete.setWhere(whereCondition.toString());
            delete.setSourceSql(ksql);
            delete.setSourceParams(params);
            DataSyncAgent.get().send(route, OperationType.DELETE, (DataSyncValue)delete);
        }
    }
}

