/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.ksql.stmt;

import java.util.List;
import kd.bos.db.DBRoute;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.ksql.DataDDLSyncValue;
import kd.bos.dts.ksql.stmt.AbstractDtsStmtHandler;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.DataSyncAgent;

public class DtsExecStmtHandler
extends AbstractDtsStmtHandler {
    @Override
    public void parse(SqlStmt sqlStmt, String ksql, Object ... params) {
        String processName = ((SqlExecStmt)sqlStmt).getOrgProcessName();
        List execParams = ((SqlExecStmt)sqlStmt).paramList;
        int tableNameParamIndex = 0;
        if ("p_DropIdx".equalsIgnoreCase(processName) || "p_AlterPK".equalsIgnoreCase(processName)) {
            tableNameParamIndex = 1;
        } else if ("p_AlterColumn".equalsIgnoreCase(processName)) {
            tableNameParamIndex = 0;
        } else if ("p_ModifyObjectName".equalsIgnoreCase(processName)) {
            String modifyType = (String)execParams.get(3);
            if ("OBJECT".equalsIgnoreCase(modifyType)) {
                tableNameParamIndex = 1;
            } else if ("COLUMN".equalsIgnoreCase(modifyType)) {
                tableNameParamIndex = 0;
            }
        } else {
            return;
        }
        String tableName = null;
        Object tableParam = execParams.get(tableNameParamIndex);
        tableName = tableParam instanceof SqlCharExpr ? ((SqlCharExpr)tableParam).text : (String)tableParam;
        if (!this.checkTable(tableName)) {
            return;
        }
        String sourceTableName = this.getOriginalName(tableName);
        DestinationTransRule[] transRules = this.syncConfig.getTransRuleByTableName(sourceTableName);
        if (transRules != null && transRules.length > 0) {
            String entityNumber = this.syncConfig.getEntityNumberByTableName(sourceTableName);
            DataDDLSyncValue ddl = new DataDDLSyncValue(tableName, entityNumber, ksql, false);
            String routeKey = DtsUtils.getDBRoutKeyByEntityNumber(entityNumber);
            DBRoute route = DBRoute.of((String)routeKey);
            ddl.setSourceSql(ksql);
            ddl.setSourceParams(params);
            DataSyncAgent.get().send(route, OperationType.DDL, (DataSyncValue)ddl);
        }
    }
}

