/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.ksql.stmt;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.ksql.DataDDLSyncValue;
import kd.bos.dts.ksql.DtsSqlHandler;
import kd.bos.dts.ksql.stmt.AbstractDtsStmtHandler;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.expr.SqlExistsExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlCreateIndexStmt;
import kd.bos.ksql.dom.stmt.SqlDeleteStmt;
import kd.bos.ksql.dom.stmt.SqlDropIndexStmt;
import kd.bos.ksql.dom.stmt.SqlDropTableStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.DataSyncAgent;

public class DtsIfStmtHandler
extends AbstractDtsStmtHandler {
    @Override
    public void parse(SqlStmt sqlStmt, String ksql, Object ... params) throws Exception {
        SqlIfStmt ifStmt = (SqlIfStmt)sqlStmt;
        SqlExpr condition = ifStmt.condition;
        Object stmt = ifStmt.trueStmtList.get(0);
        if (stmt instanceof SqlInsertStmt || stmt instanceof SqlDeleteStmt || stmt instanceof SqlUpdateStmt) {
            if (condition instanceof SqlExistsExpr) {
                SqlExistsExpr existsCondition = (SqlExistsExpr)condition;
                SqlSelect subQuery = (SqlSelect)existsCondition.subQuery;
                SqlTableSource tableSource = (SqlTableSource)subQuery.tableSource;
                String tableName = tableSource.getOrgName();
                String sourceTableName = this.getOriginalName(tableName);
                if (tableName != null && tableName.length() > 0) {
                    if (!this.checkTable(tableName)) {
                        return;
                    }
                    DestinationTransRule[] transRules = this.syncConfig.getTransRuleByTableName(sourceTableName);
                    if (transRules != null && transRules.length > 0) {
                        String entityNumber = this.syncConfig.getEntityNumberByTableName(sourceTableName);
                        String routeKey = DtsUtils.getDBRoutKeyByEntityNumber(entityNumber);
                        DBRoute route = DBRoute.of((String)routeKey);
                        StringBuilder querysql = new StringBuilder();
                        querysql.append("select 1 from ").append(tableName).append(" where ").append(subQuery.condition);
                        boolean isExists = false;
                        try (TXHandle h = TX.requiresNew();){
                            isExists = (Boolean)DB.query((DBRoute)route, (String)querysql.toString(), resultSet -> resultSet.next());
                        }
                        String ifSql = stmt.toString();
                        if (existsCondition.not && !isExists) {
                            DtsSqlHandler.handle(ifSql, params);
                        } else if (!existsCondition.not && isExists) {
                            DtsSqlHandler.handle(ifSql, params);
                        } else if (ifStmt.falseStmtList.size() > 0) {
                            String elseSql = ifStmt.falseStmtList.get(0).toString();
                            DtsSqlHandler.handle(elseSql, params);
                        }
                    }
                }
            }
        } else if ((stmt instanceof SqlDropIndexStmt || stmt instanceof SqlCreateIndexStmt || stmt instanceof SqlDropTableStmt || stmt instanceof SqlAlterTableStmt) && condition instanceof SqlExistsExpr) {
            String tableName = this.getTableName(stmt);
            if (!this.checkTable(tableName)) {
                return;
            }
            String sourceTableName = this.getOriginalName(tableName);
            DestinationTransRule[] transRules = this.syncConfig.getTransRuleByTableName(sourceTableName);
            if (transRules != null && transRules.length > 0) {
                String entityNumber = this.syncConfig.getEntityNumberByTableName(sourceTableName);
                DataDDLSyncValue ddl = new DataDDLSyncValue(tableName, entityNumber, ksql, false);
                String routeKey = DtsUtils.getDBRoutKeyByEntityNumber(entityNumber);
                DBRoute route = DBRoute.of((String)routeKey);
                ddl.setSourceSql(ksql);
                ddl.setSourceParams(params);
                DataSyncAgent.get().send(route, OperationType.DDL, (DataSyncValue)ddl);
            }
        }
    }

    private String getTableName(Object stmt) {
        String tableName = null;
        if (stmt instanceof SqlDropIndexStmt) {
            tableName = ((SqlDropIndexStmt)stmt).tableName;
        } else if (stmt instanceof SqlCreateIndexStmt) {
            tableName = ((SqlCreateIndexStmt)stmt).tableName;
        } else if (stmt instanceof SqlAlterTableStmt) {
            tableName = ((SqlAlterTableStmt)stmt).tableName;
        } else if (stmt instanceof SqlDropTableStmt) {
            tableName = ((SqlDropTableStmt)stmt).tableName;
        }
        return tableName;
    }
}

