/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.ksql.stmt;

import kd.bos.db.DBRoute;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.ksql.DataSqlInsertSyncValue;
import kd.bos.dts.ksql.stmt.AbstractDtsStmtHandler;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.DataSyncAgent;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;

public class DtsInsertStmtHandler
extends AbstractDtsStmtHandler {
    @Override
    public void parse(SqlStmt sqlStmt, String ksql, Object ... params) {
        SqlInsertStmt insertStmt = (SqlInsertStmt)sqlStmt;
        String tableName = insertStmt.insert.tableName;
        if (!this.checkTable(tableName)) {
            return;
        }
        String sourceTableName = this.getOriginalName(tableName);
        DestinationTransRule[] transRules = this.syncConfig.getTransRuleByTableName(sourceTableName);
        if (transRules != null && transRules.length > 0) {
            String entityNumber = this.syncConfig.getEntityNumberByTableName(sourceTableName);
            String routeKey = DtsUtils.getDBRoutKeyByEntityNumber(entityNumber);
            DBRoute route = DBRoute.of((String)routeKey);
            String pkField = DataSyncConfigCache.get().getPrimaryField(entityNumber, sourceTableName);
            DataSqlInsertSyncValue insert = new DataSqlInsertSyncValue(tableName, entityNumber, pkField, false);
            insert.setRouteKey(routeKey);
            insertStmt.insert.columnList.forEach(v -> insert.addClomn(v.toString()));
            insertStmt.insert.valueList.forEach(v -> insert.addValue(this.getExprValue(v)));
            insert.setCount(1);
            insert.setSourceSql(ksql);
            insert.setSourceParams(params);
            DataSyncAgent.get().send(route, OperationType.INSERT, (DataSyncValue)insert);
        }
    }
}

