/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.rateofprogress;

import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dts.init.DtsShardIndexContext;
import kd.bos.dts.rateofprogress.HessianSerializer;
import kd.bos.dts.rateofprogress.Rateofprogress;
import kd.bos.dts.rateofprogress.RateofprogressInfo;
import kd.bos.instance.Instance;

public class RateofprogressRedisImpl
implements Rateofprogress {
    private DistributeSessionlessCache cuationStore;
    private byte[] storeKey;
    private static final String STOREKEYPRE = "dts.rateofprogress.store." + Instance.getClusterName();
    private RateofprogressInfo rfgInfo;

    public RateofprogressRedisImpl(String entityKey) {
        this.storeKey = (STOREKEYPRE + entityKey).getBytes();
        this.cuationStore = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("dts");
        this.rfgInfo = new RateofprogressInfo();
    }

    @Override
    public void begin(Object o, List<Object> pkList) {
        this.rfgInfo.setShardIndex(DtsShardIndexContext.getShardIndex());
        this.rfgInfo.setLowObject(o);
        this.rfgInfo.setHighObject(null);
        this.rfgInfo.setIds(pkList);
        this.store();
    }

    @Override
    public void end(Object high) {
        this.rfgInfo.setShardIndex(DtsShardIndexContext.getShardIndex());
        this.rfgInfo.setLowObject(null);
        this.rfgInfo.setHighObject(high);
        this.rfgInfo.setIds(null);
        this.store();
    }

    private void store() {
        this.cuationStore.put(this.storeKey, HessianSerializer.serialize(this.rfgInfo), 172800);
    }

    @Override
    public RateofprogressInfo getRatePosition() {
        byte[] b = this.cuationStore.get(this.storeKey);
        if (b != null) {
            return (RateofprogressInfo)HessianSerializer.deserialize(b);
        }
        return null;
    }

    @Override
    public void clear() {
        this.cuationStore.remove(this.storeKey);
    }
}

