/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.retry;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.caution.GidCaution;
import kd.bos.dts.caution.GidCautionFactory;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.log.DtsStatusReporterFactory;
import kd.bos.dts.oplog.Oplog;
import kd.bos.dts.retry.DtsRetryContext;
import kd.bos.dts.retry.Retry;
import kd.bos.dts.retry.RetrySourceType;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.datasync.DestinationTransRule;

public class RetryConsumer
implements MessageConsumer {
    public void onMessage(Object arg0, String arg1, boolean arg2, MessageAcker arg3) {
        Map m = (Map)arg0;
        String entityNumber = (String)m.get("entityNumber");
        List ids = (List)m.get("ids");
        DestinationTransRule destRule = (DestinationTransRule)m.get("destination");
        String ckey = DtsUtils.getEntitySplitKey(entityNumber, destRule.getType().getName(), destRule.getRegion(), destRule.getMappingrule());
        GidCaution guation = GidCautionFactory.get(ckey);
        while (guation.isInitializing()) {
            LockSupport.parkNanos(1000000000L);
        }
        try (DtsRetryContext context = DtsRetryContext.create(RetrySourceType.ASYNCSENDED);){
            Retry.get().retry(destRule, entityNumber, ids);
            String businessType = destRule.getBusinessType();
            StringBuilder stringBuilder = new StringBuilder("kd.bos.dts.DtsMsgConsumer#RetryConsumer:");
            stringBuilder.append(",businessType#").append(businessType);
            stringBuilder.append(",entityNumber#").append(entityNumber);
            DtsUtils.logInfo(stringBuilder.toString());
        }
        catch (Exception e) {
            Thread.interrupted();
            Oplog.get().error(destRule.getType().getName() + "-" + destRule.getRegion(), "retry insert", entityNumber, 0, ExceptionLogger.getStack((Throwable)e));
            DestinationRuleConfig entityRuleConfig = DestinationRuleConfig.get((String)entityNumber, (DestinationTransRule)destRule);
            DtsStatusReporterFactory.get().confInitCountReportError(e, entityRuleConfig, ids.size(), "retry insert");
            Retry.get().failedForRetryIds(destRule, entityNumber, ids);
            return;
        }
    }
}

