/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.retry;

import java.util.List;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.dts.log.DtsStatusReporterFactory;
import kd.bos.dts.retry.DtsRetryContext;
import kd.bos.dts.retry.Retry;
import kd.bos.dts.retry.RetrySourceType;
import kd.bos.dts.retry.RetryStroage;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.util.SafeLogUtils;

public class RetryService {
    public static void checkAndModify() {
        List<Long> configs = RetryStroage.get().queryRetryList();
        configs.forEach(v -> {
            List<Object> retryids = null;
            DestinationRuleConfig config = RetryStroage.get().getConfig((Long)v);
            if (config == null) {
                RetryStroage.get().removeItem((Long)v);
            }
            if ((retryids = RetryStroage.get().queryRetryIds((Long)v)).size() == 0) {
                return;
            }
            try (DtsRetryContext context = DtsRetryContext.create(RetrySourceType.BACKGROUNDTASK);){
                DestinationTransRule rule = config.getRule();
                String entityNumber = config.getEntityNumber();
                try {
                    Retry.get().retry(rule, entityNumber, retryids);
                }
                catch (Exception se) {
                    SafeLogUtils.error(RetryService.class, (String)"checkAndModifyError", (Throwable)se);
                }
                DtsSnapConfigDao.instance.resumeOnlineException(entityNumber, rule);
                RetryStroage.get().removeItem((Long)v);
            }
            catch (Exception e) {
                DtsStatusReporterFactory.get().confInitCountReportError(e, config, retryids.size(), "RetryService");
            }
        });
    }
}

