/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.service;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.init.table.TableInitialize;
import kd.bos.dts.service.DtsConfigMonitor;
import kd.bos.dts.service.DtsMQueueDefManager;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.QueueManager;
import kd.bos.orm.datasync.DtsAccountPowerListener;
import kd.bos.orm.datasync.DtsThreadContext;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;

public class DtsAccountPowerMasterListenerImpl
implements DtsAccountPowerListener {
    private String appid;

    public DtsAccountPowerMasterListenerImpl(String appid) {
        this.appid = appid;
    }

    public void disable(Account account) {
        try {
            ThreadLifeCycleManager.start();
            RequestContext context = RequestContext.create();
            context.setAccountId(account.getAccountId());
            context.setTenantId(account.getTenantId());
            this.stopDtsMqConsumer();
        }
        finally {
            ThreadLifeCycleManager.end();
        }
    }

    public void enable(Account account) {
        CountDownLatch latch = new CountDownLatch(1);
        ThreadPools.executeOnce((String)"DtsAccountPowerListener-Enable", () -> {
            block27: {
                try {
                    ThreadLifeCycleManager.start();
                    RequestContext context = RequestContext.create();
                    context.setAccountId(account.getAccountId());
                    context.setTenantId(account.getTenantId());
                    this.startDtsMqConsumer();
                    DataSyncConfigCache.get().initConfig();
                    if (!this.appid.equalsIgnoreCase("dts")) break block27;
                    TableInitialize.initTable();
                    try (TXHandle tx = TX.requiresNew();
                         DtsThreadContext dtsContext = DtsThreadContext.create();){
                        DB.execute((DBRoute)DBRoute.basedata, (String)"delete from t_dts_syncconfigsnapshot", (Object[])new Object[0]);
                    }
                    DtsConfigMonitor.get().doInitConfig();
                }
                finally {
                    latch.countDown();
                    ThreadLifeCycleManager.end();
                }
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void startDtsMqConsumer() {
        DtsMQueueDefManager.initCurrentDtsQueueDefs();
        Set<String> queueNames = this.getCurrentDtsQueueNames();
        for (String queueName : queueNames) {
            Consumer conumer = QueueManager.getLazyInitConsumer((String)"dts", (String)queueName);
            DtsMQueueDefManager.start(conumer);
        }
        DtsMQueueDefManager.addQueueNamesForAccountEnable(this.appid, queueNames);
    }

    private void stopDtsMqConsumer() {
        Set<String> queueNames = this.getCurrentDtsQueueNames();
        for (String queueName : queueNames) {
            Consumer conumer = QueueManager.getLazyInitConsumer((String)"dts", (String)queueName);
            DtsMQueueDefManager.stop(conumer);
        }
        DtsMQueueDefManager.removeQueueNamesForAccountDisenable(this.appid, queueNames);
    }

    private Set<String> getCurrentDtsQueueNames() {
        Set<String> currentDtsQueueNames = DtsMQueueDefManager.getCurrentDtsQueueNames();
        HashSet<String> queueNames = new HashSet(2);
        if (DtsUtils.dtsBizRunEnable()) {
            for (String queueName : currentDtsQueueNames) {
                String splitAppid = DtsUtils.getAppidBuQueueName(queueName);
                if (!this.appid.equalsIgnoreCase(splitAppid)) continue;
                queueNames.add(queueName);
            }
        } else {
            queueNames = currentDtsQueueNames;
        }
        return queueNames;
    }
}

