/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.syncconfig;

import java.util.Map;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;

public class DestinationRuleConfigHelper {
    public static DestinationRuleConfig getDestinationConfig(String businessType, String region, String destinationType, String entityNumber) {
        DestinationTransRule[] rules;
        for (DestinationTransRule rule : rules = DataSyncConfigCache.get().getEntitySyncDestinationType(entityNumber)) {
            if (!rule.getRegion().equals(region) || !rule.getType().getName().equals(destinationType)) continue;
            DestinationRuleConfig config = DestinationRuleConfig.get((String)entityNumber, (DestinationTransRule)rule);
            return config;
        }
        Map<String, SyncConfigInfo> map = DtsSnapConfigDao.instance.getConfigItem(entityNumber);
        for (Map.Entry<String, SyncConfigInfo> entry : map.entrySet()) {
            SyncConfigInfo sci = entry.getValue();
            if (!sci.getRegion().equals(region) || !sci.getDestinationtype().equals(destinationType)) continue;
            DestinationTransRule rule = new DestinationTransRule();
            rule.setBusinessType(businessType);
            rule.setRegion(region);
            rule.setType(DestinationType.getType((String)destinationType));
            rule.setMappingrule(sci.getMappingrule());
            DestinationRuleConfig config = DestinationRuleConfig.get((String)entityNumber, (DestinationTransRule)rule);
            return config;
        }
        return null;
    }

    public static DestinationRuleConfig getDestinationConfig(String businessType, String region, String mappingRule, String destinationType, String entityNumber) {
        DestinationTransRule[] rules;
        if (mappingRule == null || mappingRule.trim().length() == 0) {
            mappingRule = "";
        }
        for (DestinationTransRule rule : rules = DataSyncConfigCache.get().getEntitySyncDestinationType(entityNumber)) {
            if (!rule.getRegion().equals(region) || !rule.getType().getName().equals(destinationType) || !rule.getMappingrule().equals(mappingRule)) continue;
            DestinationRuleConfig config = DestinationRuleConfig.get((String)entityNumber, (DestinationTransRule)rule);
            return config;
        }
        Map<String, SyncConfigInfo> map = DtsSnapConfigDao.instance.getConfigItem(entityNumber);
        for (Map.Entry<String, SyncConfigInfo> entry : map.entrySet()) {
            SyncConfigInfo sci = entry.getValue();
            if (!sci.getRegion().equals(region) || !sci.getDestinationtype().equals(destinationType) || !sci.getMappingrule().equals(mappingRule)) continue;
            DestinationTransRule rule = new DestinationTransRule();
            rule.setBusinessType(businessType);
            rule.setRegion(region);
            rule.setType(DestinationType.getType((String)destinationType));
            rule.setMappingrule(sci.getMappingrule());
            DestinationRuleConfig config = DestinationRuleConfig.get((String)entityNumber, (DestinationTransRule)rule);
            return config;
        }
        return null;
    }
}

