/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.exception;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import kd.sdk.kingscript.exception.InternalExceptionCat;

public abstract class AbstractTruffleException
extends RuntimeException
implements TruffleObject,
TruffleException {
    public static final int UNLIMITED_STACK_TRACE = -1;
    private final int stackTraceElementLimit;
    private final Throwable cause;
    private final Node location;
    private Throwable lazyStackTrace;

    protected AbstractTruffleException() {
        this(null, null, -1, null);
    }

    protected AbstractTruffleException(Node location) {
        this(null, null, -1, location);
    }

    protected AbstractTruffleException(String message) {
        this(message, null, -1, null);
    }

    protected AbstractTruffleException(String message, Node location) {
        this(message, null, -1, location);
    }

    @CompilerDirectives.TruffleBoundary
    protected AbstractTruffleException(AbstractTruffleException prototype) {
        this(prototype.getMessage(), prototype.getCause(), prototype.getStackTraceElementLimit(), prototype.getLocation());
        for (Throwable t : prototype.getSuppressed()) {
            this.addSuppressed(t);
        }
        TruffleStackTrace.fillIn((Throwable)prototype);
        assert (prototype.lazyStackTrace != null) : "Prototype must have a stack trace after fillIn.";
        this.lazyStackTrace = prototype.lazyStackTrace;
    }

    protected AbstractTruffleException(String message, Throwable cause, int stackTraceElementLimit, Node location) {
        super(message, cause);
        this.stackTraceElementLimit = stackTraceElementLimit;
        this.cause = cause;
        this.location = location;
        KingScriptChanges.fixed("\u83b7\u53d6\u771f\u6b63\u7684\u5f02\u5e38");
        InternalExceptionCat.cat(message, cause);
    }

    @Override
    public final Throwable fillInStackTrace() {
        return this;
    }

    public final Node getLocation() {
        return this.location;
    }

    public final int getStackTraceElementLimit() {
        return this.stackTraceElementLimit;
    }

    @Deprecated
    public final SourceSection getSourceLocation() {
        InteropLibrary interop = InteropLibrary.getUncached();
        if (interop.hasSourceLocation((Object)this)) {
            try {
                return interop.getSourceLocation((Object)this);
            }
            catch (UnsupportedMessageException um) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)um);
            }
        }
        return null;
    }

    @Deprecated
    public final Object getExceptionObject() {
        return this;
    }

    @Deprecated
    public final boolean isSyntaxError() {
        return this.getExceptionType() == ExceptionType.PARSE_ERROR;
    }

    @Deprecated
    public final boolean isIncompleteSource() {
        try {
            return InteropLibrary.getUncached().isExceptionIncompleteSource((Object)this);
        }
        catch (UnsupportedMessageException um) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)um);
        }
    }

    @Deprecated
    public final boolean isInternalError() {
        return false;
    }

    @Deprecated
    public final boolean isCancelled() {
        return false;
    }

    @Deprecated
    public final boolean isExit() {
        return this.getExceptionType() == ExceptionType.EXIT;
    }

    @Deprecated
    public final int getExitStatus() {
        try {
            return InteropLibrary.getUncached().getExceptionExitStatus((Object)this);
        }
        catch (UnsupportedMessageException um) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)um);
        }
    }

    @Override
    @Deprecated
    @CompilerDirectives.TruffleBoundary
    public final Throwable initCause(Throwable throwable) {
        throw new UnsupportedOperationException("Not supported. Pass in the cause using the constructors instead.");
    }

    @Override
    public final Throwable getCause() {
        return this.cause;
    }

    Throwable getLazyStackTrace() {
        return this.lazyStackTrace;
    }

    void setLazyStackTrace(Throwable stackTrace) {
        this.lazyStackTrace = stackTrace;
    }

    private ExceptionType getExceptionType() {
        try {
            return InteropLibrary.getUncached().getExceptionType((Object)this);
        }
        catch (UnsupportedMessageException um) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)um);
        }
    }

    static boolean isTruffleException(Throwable t) {
        return t instanceof TruffleException;
    }
}

