/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.ArrayIterator;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;

final class InteropAccessor
extends Accessor {
    static final InteropAccessor ACCESSOR = new InteropAccessor();
    static final Accessor.LanguageSupport LANGUAGE = ACCESSOR.languageSupport();
    static final Accessor.ExceptionSupport EXCEPTION = ACCESSOR.exceptionSupport();
    static final Accessor.InstrumentSupport INSTRUMENT = ACCESSOR.instrumentSupport();
    static final Accessor.NodeSupport NODES = ACCESSOR.nodeSupport();
    static final Accessor.HostSupport HOST = ACCESSOR.hostSupport();

    private InteropAccessor() {
    }

    static Object checkInteropType(Object obj) {
        KingScriptChanges.fixed("fix Debug\u62a5\u9519: com.oracle.truffle.js.runtime.objects.ExportResolution$Resolved isn't allowed Truffle interop type!");
        return obj;
    }

    private static boolean checkInteropTypeImpl(Object obj) {
        if (InteropLibrary.isValidValue((Object)obj)) {
            return true;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        Class<?> clazz = obj != null ? obj.getClass() : null;
        return InteropAccessor.yieldAnError(clazz);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean yieldAnError(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append(clazz == null ? "null" : clazz.getName());
        sb.append(" isn't allowed Truffle interop type!\n");
        if (clazz == null) {
            throw new NullPointerException(sb.toString());
        }
        throw new ClassCastException(sb.toString());
    }

    static final class EmptyTruffleObject {
        static final EmptyTruffleObject INSTANCE = new EmptyTruffleObject();

        EmptyTruffleObject() {
        }
    }

    static class InteropImpl
    extends Accessor.InteropSupport {
        InteropImpl() {
        }

        public boolean isTruffleObject(Object value) {
            return value instanceof TruffleObject;
        }

        public void checkInteropType(Object result) {
            InteropAccessor.checkInteropType(result);
        }

        public boolean isExecutableObject(Object value) {
            return InteropLibrary.getUncached().isExecutable(value);
        }

        public boolean isScopeObject(Object receiver) {
            InteropLibrary interop = InteropLibrary.getUncached();
            return interop.isScope(receiver) && interop.hasMembers(receiver);
        }

        public Object createDefaultNodeObject(Node node) {
            return EmptyTruffleObject.INSTANCE;
        }

        public Object createDefaultIterator(Object receiver) {
            return new ArrayIterator(receiver);
        }
    }
}

