/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import org.graalvm.polyglot.io.ByteSequence;

class SourceSnippets {
    public static boolean loaded = true;

    SourceSnippets() {
    }

    public static Source fromFile(TruffleFile file) throws IOException {
        assert (file.getName().endsWith(".java")) : "Imagine 'c:\\sources\\Example.java' file";
        String language = Source.findLanguage(file);
        Source source = Source.newBuilder(language, file).build();
        assert (file.getName().equals(source.getName()));
        assert (file.getPath().equals(source.getPath()));
        assert (file.toUri().equals(source.getURI()));
        return source;
    }

    public static Source likeFileName(TruffleFile file) throws IOException {
        String language = Source.findLanguage(file);
        Source source = Source.newBuilder(language, file.getCanonicalFile(new LinkOption[0])).name(file.getPath()).build();
        return source;
    }

    public static Source fromURL(Class<?> relativeClass) throws IOException, URISyntaxException {
        URL resource = relativeClass.getResource("sample.js");
        Source source = Source.newBuilder("js", resource).build();
        assert (resource.toExternalForm().equals(source.getPath()));
        assert ("sample.js".equals(source.getName()));
        assert (resource.toURI().equals(source.getURI()));
        return source;
    }

    public static Source fromURLWithOwnContent(Class<?> relativeClass) {
        URL resource = relativeClass.getResource("sample.js");
        Source source = Source.newBuilder("js", resource).content("{}").build();
        assert (resource.toExternalForm().equals(source.getPath()));
        assert ("sample.js".equals(source.getName()));
        assert (resource.toExternalForm().equals(source.getURI().toString()));
        assert ("{}".equals(source.getCharacters()));
        return source;
    }

    public static Source fromReader(Class<?> relativeClass) throws IOException {
        InputStreamReader stream = new InputStreamReader(relativeClass.getResourceAsStream("sample.js"));
        Source source = Source.newBuilder("js", stream, "sample.js").build();
        assert ("sample.js".equals(source.getName()));
        return source;
    }

    public static Source fromAString() {
        Source source = Source.newBuilder("js", "function() {\n  return 'Hi';\n}\n", "hi.js").build();
        assert ("hi.js".equals(source.getName()));
        return source;
    }

    public static Source fromBytes() {
        byte[] bytes = new byte[]{};
        Source source = Source.newBuilder("llvm", ByteSequence.create((byte[])bytes), "<literal>").build();
        return source;
    }
}

