/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.host.HostContext;
import com.oracle.truffle.host.HostTargetMappingNode;
import com.oracle.truffle.host.HostToTypeNode;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.lang.reflect.Type;

class JSArrayTypes {
    JSArrayTypes() {
    }

    static boolean canConvertArray(JSArrayObject value, Class<?> targetType, Type genericType, Boolean allowsImplementation, HostContext hostContext, int priority, InteropLibrary interop, HostTargetMappingNode targetMapping) {
        long n = value.getArraySize();
        for (long i = 0L; i < n; ++i) {
            Object item = value.getValue(i);
            if (item == null || item == Undefined.instance) continue;
            return HostToTypeNode.canConvert(item, targetType.getComponentType(), genericType, allowsImplementation, hostContext, priority, interop, targetMapping);
        }
        return true;
    }

    static boolean isTypeOf(Class<?> clazz, Class<?> targetType) {
        if (clazz == targetType) {
            return true;
        }
        if (targetType.isPrimitive()) {
            targetType = JSArrayTypes.getWrapperClass(targetType);
        }
        return targetType.isAssignableFrom(clazz);
    }

    private static Class<?> getWrapperClass(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        return clazz;
    }
}

