/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.module;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.runtime.Evaluator;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import java.util.Set;

public class ResolveNamedImportNode
extends StatementNode {
    private final JSContext context;
    private final Module.ModuleRequest moduleRequest;
    private final String importName;
    @Node.Child
    private JavaScriptNode moduleNode;
    @Node.Child
    private JSWriteFrameSlotNode writeLocalNode;
    private final ValueProfile resolutionProfile = ValueProfile.createClassProfile();

    ResolveNamedImportNode(JSContext context, JavaScriptNode moduleNode, Module.ModuleRequest moduleRequest, String importName, JSWriteFrameSlotNode writeLocalNode) {
        this.context = context;
        this.moduleRequest = moduleRequest;
        this.moduleNode = moduleNode;
        this.importName = importName;
        this.writeLocalNode = writeLocalNode;
    }

    public static StatementNode create(JSContext context, JavaScriptNode moduleNode, Module.ModuleRequest moduleRequest, String importName, JSWriteFrameSlotNode writeLocalNode) {
        return new ResolveNamedImportNode(context, moduleNode, moduleRequest, importName, writeLocalNode);
    }

    public Object execute(VirtualFrame frame) {
        JSModuleRecord importedModule;
        JSModuleRecord referencingScriptOrModule = (JSModuleRecord)this.moduleNode.execute(frame);
        Evaluator evaluator = this.context.getEvaluator();
        ExportResolution resolution = (ExportResolution)this.resolutionProfile.profile((Object)evaluator.resolveExport(importedModule = evaluator.hostResolveImportedModule(this.context, (ScriptOrModule)referencingScriptOrModule, this.moduleRequest), this.importName));
        if (resolution.isNull() || resolution.isAmbiguous()) {
            KingScriptChanges.fixed("\u5ffd\u7565\u6267\u884cts\u6e90\u7801import declare\u63a5\u53e3\u4e0d\u5b58\u5728\u7684\u9519\u8bef");
            return EMPTY;
        }
        ExportResolution resolutionOrNamespace = resolution.isNamespace() ? evaluator.getModuleNamespace(resolution.getModule()) : resolution;
        this.writeLocalNode.executeWrite(frame, (Object)resolutionOrNamespace);
        return EMPTY;
    }

    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ResolveNamedImportNode.create(this.context, ResolveNamedImportNode.cloneUninitialized((JavaScriptNode)this.moduleNode, materializedTags), this.moduleRequest, this.importName, (JSWriteFrameSlotNode)ResolveNamedImportNode.cloneUninitialized((JavaScriptNode)this.writeLocalNode, materializedTags));
    }
}

