/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSDictionary;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSGlobalObject;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DefinePropertyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.engine.bindings.ClearConstContext;
import kd.sdk.kingscript.engine.bindings.ScriptBindingsImpl;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.global.GlobalObject;

public abstract class JSNonProxy
extends JSClass {
    protected JSNonProxy() {
    }

    @CompilerDirectives.TruffleBoundary
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        return DefinePropertyUtil.ordinaryDefineOwnProperty((DynamicObject)thisObj, (Object)key, (PropertyDescriptor)desc, (boolean)doThrow);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, Object key, Node encapsulatingNode) {
        Property entry = DefinePropertyUtil.getPropertyByKey((DynamicObject)store, (Object)key);
        if (entry != null) {
            return JSProperty.getValue((Property)entry, (DynamicObject)store, (Object)thisObj, (Node)encapsulatingNode);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, long index, Node encapsulatingNode) {
        return this.getOwnHelper(store, thisObj, String.valueOf(index), encapsulatingNode);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getHelper(DynamicObject store, Object thisObj, Object key, Node encapsulatingNode) {
        Object value = this.getOwnHelper(store, thisObj, key, encapsulatingNode);
        if (value != null) {
            return value;
        }
        return JSNonProxy.getPropertyHelperGeneric(thisObj, store, key, encapsulatingNode);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object getPropertyHelperGeneric(Object thisObj, DynamicObject store, Object key, Node encapsulatingNode) {
        DynamicObject prototype = JSObject.getPrototype((DynamicObject)store);
        if (prototype != Null.instance) {
            return JSObject.getJSClass((DynamicObject)prototype).getHelper(prototype, thisObj, key, encapsulatingNode);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public Object getHelper(DynamicObject store, Object thisObj, long index, Node encapsulatingNode) {
        Object value = this.getOwnHelper(store, thisObj, index, encapsulatingNode);
        if (value != null) {
            return value;
        }
        return JSNonProxy.getPropertyHelperGeneric(thisObj, store, index, encapsulatingNode);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object getPropertyHelperGeneric(Object thisObj, DynamicObject store, long index, Node encapsulatingNode) {
        DynamicObject prototype = JSObject.getPrototype((DynamicObject)store);
        if (prototype != Null.instance) {
            return JSObject.getJSClass((DynamicObject)prototype).getHelper(prototype, thisObj, index, encapsulatingNode);
        }
        return null;
    }

    public Object getMethodHelper(DynamicObject store, Object thisObj, Object name, Node encapsulatingNode) {
        return this.getHelper(store, thisObj, name, encapsulatingNode);
    }

    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        return JSNonProxy.ordinaryOwnPropertyKeys(thisObj, strings, symbols);
    }

    public static List<Object> ordinaryOwnPropertyKeys(DynamicObject thisObj) {
        return JSNonProxy.ordinaryOwnPropertyKeys(thisObj, true, true);
    }

    @CompilerDirectives.TruffleBoundary
    protected static List<Object> ordinaryOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        return JSShape.getPropertyKeyList((Shape)thisObj.getShape(), (boolean)strings, (boolean)symbols);
    }

    protected static List<Object> ordinaryOwnPropertyKeysSlow(DynamicObject thisObj, boolean strings, boolean symbols) {
        CompilerAsserts.neverPartOfCompilation();
        List keyList = thisObj.getShape().getKeyList();
        ArrayList<Object> list = new ArrayList<Object>(keyList.size());
        for (Object key : keyList) {
            if (!symbols && key instanceof Symbol || !strings && key instanceof String) continue;
            list.add(key);
        }
        Collections.sort(list, JSRuntime::comparePropertyKeys);
        return list;
    }

    public boolean hasOnlyShapeProperties(DynamicObject obj) {
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        return JSNonProxy.deletePropertyDefault(thisObj, key, isStrict);
    }

    protected static boolean deletePropertyDefault(DynamicObject object, Object key, boolean isStrict) {
        Property foundProperty = object.getShape().getProperty(key);
        if (foundProperty != null) {
            if (!JSProperty.isConfigurable((Property)foundProperty)) {
                if (isStrict) {
                    throw Errors.createTypeErrorNotConfigurableProperty((Object)key);
                }
                return false;
            }
            KingScriptChanges.fixed("\u7981\u6b62\u7528\u6237\u4f7f\u7528\u811a\u672c\u5220\u9664\u5185\u7f6e\u5168\u5c40\u53d8\u91cf");
            if (object instanceof JSGlobalObject) {
                if (GlobalObject.getGlobalMembers().contains(key)) {
                    return false;
                }
                KingScriptEngineImpl engine = KingScriptEngineImpl.getCurrentEngineImpl();
                if (engine != null) {
                    if (((ScriptBindingsImpl)engine.getBindings()).constKeySet0().contains(key)) {
                        if (!ClearConstContext.canClear()) {
                            if (isStrict) {
                                throw new ScriptException("[strict model] now allow delete const object: " + key);
                            }
                            return false;
                        }
                    } else if (((ScriptBindingsImpl)engine.getBindings()).globalKeySet0().contains(key)) {
                        if (isStrict) {
                            throw new ScriptException("[strict model] now allow delete global object: " + key);
                        }
                        return false;
                    }
                }
            }
            return DynamicObjectLibrary.getUncached().removeKey(object, key);
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        return JSNonProxy.deletePropertyDefault(thisObj, String.valueOf(index), isStrict);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        return thisObj.getShape().hasProperty(key);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, long index) {
        return this.hasOwnProperty(thisObj, String.valueOf(index));
    }

    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(DynamicObject thisObj, long index) {
        if (this.hasOwnProperty(thisObj, index)) {
            return true;
        }
        if (JSObject.getPrototype((DynamicObject)thisObj) != Null.instance) {
            return JSObject.hasProperty((DynamicObject)JSObject.getPrototype((DynamicObject)thisObj), (long)index);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(DynamicObject thisObj, Object key) {
        if (this.hasOwnProperty(thisObj, key)) {
            return true;
        }
        DynamicObject prototype = JSObject.getPrototype((DynamicObject)thisObj);
        if (prototype != Null.instance) {
            return JSObject.hasProperty((DynamicObject)prototype, (Object)key);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        return JSNonProxy.ordinarySetIndex(thisObj, index, value, receiver, isStrict, encapsulatingNode);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        return JSNonProxy.ordinarySet(thisObj, key, value, receiver, isStrict, encapsulatingNode);
    }

    protected static boolean ordinarySetIndex(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        String key = Boundaries.stringValueOf((long)index);
        if (receiver != thisObj) {
            return JSNonProxy.ordinarySetWithReceiver(thisObj, key, value, receiver, isStrict, encapsulatingNode);
        }
        Property entry = DefinePropertyUtil.getPropertyByKey((DynamicObject)thisObj, (Object)key);
        if (entry != null) {
            return JSProperty.setValue((Property)entry, (DynamicObject)thisObj, (Object)receiver, (Object)value, (boolean)isStrict, (Node)encapsulatingNode);
        }
        return JSNonProxy.setPropertySlow(thisObj, key, value, receiver, isStrict, true, encapsulatingNode);
    }

    protected static boolean ordinarySet(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        if (receiver != thisObj) {
            return JSNonProxy.ordinarySetWithReceiver(thisObj, key, value, receiver, isStrict, encapsulatingNode);
        }
        Property entry = DefinePropertyUtil.getPropertyByKey((DynamicObject)thisObj, (Object)key);
        if (entry != null) {
            return JSProperty.setValue((Property)entry, (DynamicObject)thisObj, (Object)receiver, (Object)value, (boolean)isStrict, (Node)encapsulatingNode);
        }
        return JSNonProxy.setPropertySlow(thisObj, key, value, receiver, isStrict, false, encapsulatingNode);
    }

    protected static boolean ordinarySetWithReceiver(DynamicObject target, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        assert (JSRuntime.isPropertyKey(key));
        PropertyDescriptor descriptor = JSObject.getOwnProperty((DynamicObject)target, (Object)key);
        boolean result = JSNonProxy.performOrdinarySetWithOwnDescriptor(target, key, value, receiver, descriptor, isStrict, encapsulatingNode);
        assert (!isStrict || result) : "should have thrown";
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    protected static boolean performOrdinarySetWithOwnDescriptor(DynamicObject target, Object key, Object value, Object receiver, PropertyDescriptor desc, boolean isStrict, Node encapsulatingNode) {
        PropertyDescriptor descriptor = desc;
        if (descriptor == null) {
            DynamicObject parent = JSObject.getPrototype((DynamicObject)target);
            if (parent != Null.instance) {
                return JSObject.getJSClass((DynamicObject)parent).set(parent, key, value, receiver, isStrict, encapsulatingNode);
            }
            descriptor = PropertyDescriptor.undefinedDataDesc;
        }
        if (descriptor.isDataDescriptor()) {
            if (!descriptor.getWritable()) {
                if (isStrict) {
                    throw Errors.createTypeErrorNotWritableProperty((Object)key, (Object)target);
                }
                return false;
            }
            if (!JSRuntime.isObject(receiver)) {
                if (isStrict) {
                    throw Errors.createTypeErrorSetNonObjectReceiver((Object)receiver, (Object)key);
                }
                return false;
            }
            DynamicObject receiverObj = (DynamicObject)receiver;
            PropertyDescriptor existingDesc = JSObject.getOwnProperty((DynamicObject)receiverObj, (Object)key);
            if (existingDesc != null) {
                if (existingDesc.isAccessorDescriptor()) {
                    if (isStrict) {
                        throw Errors.createTypeErrorCannotRedefineProperty((Object)key);
                    }
                    return false;
                }
                if (!existingDesc.getWritable()) {
                    if (isStrict) {
                        throw Errors.createTypeErrorNotWritableProperty((Object)key, (Object)receiverObj);
                    }
                    return false;
                }
                PropertyDescriptor valueDesc = PropertyDescriptor.createData((Object)value);
                return JSObject.defineOwnProperty((DynamicObject)receiverObj, (Object)key, (PropertyDescriptor)valueDesc, (boolean)isStrict);
            }
            return JSRuntime.createDataProperty(receiverObj, key, value, isStrict);
        }
        assert (descriptor.isAccessorDescriptor());
        Object setter = descriptor.getSet();
        if (setter == Undefined.instance || setter == null) {
            if (isStrict) {
                throw Errors.createTypeErrorCannotSetAccessorProperty((Object)key, (DynamicObject)target);
            }
            return false;
        }
        JSRuntime.call(setter, receiver, new Object[]{value}, encapsulatingNode);
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    protected static boolean setPropertySlow(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, boolean isIndex, Node encapsulatingNode) {
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject current = JSObject.getPrototype((DynamicObject)thisObj);
        while (current != Null.instance) {
            if (JSProxy.isJSProxy((Object)current)) {
                return JSObject.getJSClass((DynamicObject)current).set(current, key, value, receiver, isStrict, encapsulatingNode);
            }
            PropertyDescriptor desc = JSObject.getOwnProperty((DynamicObject)current, (Object)key);
            if (desc != null) {
                if (desc.isDataDescriptor() && !desc.getWritable()) {
                    if (isStrict) {
                        throw Errors.createTypeErrorNotWritableProperty((Object)key, (Object)current);
                    }
                    return false;
                }
                if (!desc.isAccessorDescriptor()) break;
                return JSNonProxy.invokeAccessorPropertySetter(desc, thisObj, key, value, receiver, isStrict, encapsulatingNode);
            }
            current = JSObject.getPrototype((DynamicObject)current);
        }
        assert (thisObj == receiver);
        DynamicObject receiverObj = (DynamicObject)receiver;
        if (!JSObject.isExtensible((DynamicObject)receiverObj)) {
            if (isStrict) {
                throw Errors.createTypeErrorNotExtensible((DynamicObject)receiverObj, (Object)key);
            }
            return false;
        }
        boolean isDictionaryObject = JSDictionary.isJSDictionaryObject((DynamicObject)thisObj);
        if (!isDictionaryObject && JSNonProxy.isDictionaryObjectCandidate(thisObj, isIndex)) {
            JSDictionary.makeDictionaryObject((DynamicObject)thisObj, (String)"set");
            isDictionaryObject = true;
        }
        if (isDictionaryObject) {
            JSDictionary.getHashMap((DynamicObject)thisObj).put(key, (Object)PropertyDescriptor.createDataDefault((Object)value));
            return true;
        }
        JSContext context = JSObject.getJSContext((DynamicObject)thisObj);
        JSObjectUtil.putDataProperty((JSContext)context, (DynamicObject)thisObj, (Object)key, (Object)value, (int)JSAttributes.getDefault());
        return true;
    }

    protected static boolean invokeAccessorPropertySetter(PropertyDescriptor desc, DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (desc.isAccessorDescriptor());
        DynamicObject setter = (DynamicObject)desc.getSet();
        if (setter != Undefined.instance) {
            JSRuntime.call(setter, receiver, new Object[]{value}, encapsulatingNode);
            return true;
        }
        if (isStrict) {
            throw Errors.createTypeErrorCannotSetAccessorProperty((Object)key, (DynamicObject)thisObj);
        }
        return false;
    }

    private static boolean isDictionaryObjectCandidate(DynamicObject thisObj, boolean isIndex) {
        if (!JSOrdinary.isJSOrdinaryObject((DynamicObject)thisObj)) {
            return false;
        }
        int count = thisObj.getShape().getPropertyCount();
        return count == 0 && isIndex || count == 1024;
    }

    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        return JSNonProxy.ordinaryGetOwnProperty(thisObj, key);
    }

    public static PropertyDescriptor ordinaryGetOwnProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        Property prop = thisObj.getShape().getProperty(key);
        if (prop == null) {
            return null;
        }
        return JSNonProxy.ordinaryGetOwnPropertyIntl(thisObj, key, prop);
    }

    @CompilerDirectives.TruffleBoundary
    public static PropertyDescriptor ordinaryGetOwnPropertyIntl(DynamicObject thisObj, Object key, Property prop) {
        PropertyDescriptor desc;
        if (JSProperty.isData((Property)prop)) {
            Object value = JSDynamicObject.getOrNull((DynamicObject)thisObj, (Object)key);
            if (JSProperty.isProxy((Property)prop)) {
                value = ((PropertyProxy)value).get(thisObj);
            }
            desc = PropertyDescriptor.createData((Object)value);
            desc.setWritable(JSProperty.isWritable((Property)prop));
        } else if (JSProperty.isAccessor((Property)prop)) {
            Accessor acc = (Accessor)JSDynamicObject.getOrNull((DynamicObject)thisObj, (Object)key);
            desc = PropertyDescriptor.createAccessor((DynamicObject)acc.getGetter(), (DynamicObject)acc.getSetter());
        } else {
            desc = PropertyDescriptor.createEmpty();
        }
        desc.setEnumerable(JSProperty.isEnumerable((Property)prop));
        desc.setConfigurable(JSProperty.isConfigurable((Property)prop));
        return desc;
    }

    public boolean setIntegrityLevel(DynamicObject thisObj, boolean freeze, boolean doThrow) {
        if (this.usesOrdinaryGetOwnProperty()) {
            return this.setIntegrityLevelFast(thisObj, freeze);
        }
        return super.setIntegrityLevel(thisObj, freeze, doThrow);
    }

    @CompilerDirectives.TruffleBoundary
    protected final boolean setIntegrityLevelFast(DynamicObject thisObj, boolean freeze) {
        if (JSNonProxy.testIntegrityLevelFast(thisObj, freeze)) {
            return true;
        }
        for (Property property : JSDynamicObject.getPropertyArray((DynamicObject)thisObj)) {
            if (property.isHidden()) continue;
            int oldFlags = property.getFlags();
            int newFlags = oldFlags | 2;
            if (freeze && (oldFlags & 8) == 0) {
                newFlags |= 4;
            }
            if (newFlags == oldFlags) continue;
            Object key = property.getKey();
            JSDynamicObject.setPropertyFlags((DynamicObject)thisObj, (Object)key, (int)newFlags);
            assert (JSDynamicObject.getPropertyFlags((DynamicObject)thisObj, (Object)key) == newFlags);
        }
        assert (JSNonProxy.testSealedProperties(thisObj) && (!freeze || JSNonProxy.testFrozenProperties(thisObj)));
        boolean result = this.preventExtensionsImpl(thisObj, 2 | (freeze ? 4 : 0));
        assert (result && this.testIntegrityLevel(thisObj, freeze));
        return true;
    }

    public boolean testIntegrityLevel(DynamicObject obj, boolean frozen) {
        if (this.usesOrdinaryGetOwnProperty()) {
            return JSNonProxy.testIntegrityLevelFast(obj, frozen);
        }
        return super.testIntegrityLevel(obj, frozen);
    }

    @CompilerDirectives.TruffleBoundary
    protected static boolean testIntegrityLevelFast(DynamicObject obj, boolean frozen) {
        int objectFlags = JSDynamicObject.getObjectFlags((DynamicObject)obj);
        if (frozen) {
            return (objectFlags & 4) != 0;
        }
        return (objectFlags & 2) != 0;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean preventExtensions(DynamicObject thisObj, boolean doThrow) {
        return this.preventExtensionsImpl(thisObj, 0);
    }

    protected final boolean preventExtensionsImpl(DynamicObject thisObj, int extraFlags) {
        int objectFlags = JSDynamicObject.getObjectFlags((DynamicObject)thisObj);
        if ((objectFlags & 1) != 0 && (objectFlags & extraFlags) == extraFlags) {
            return true;
        }
        int newFlags = objectFlags | 1 | extraFlags;
        if ((newFlags & 2) == 0 && JSNonProxy.testSealedProperties(thisObj)) {
            newFlags |= 2;
        }
        if ((newFlags & 2) != 0 && (newFlags & 4) == 0 && JSNonProxy.testFrozenProperties(thisObj)) {
            newFlags |= 4;
        }
        if (newFlags != objectFlags) {
            JSDynamicObject.setObjectFlags((DynamicObject)thisObj, (int)newFlags);
        }
        assert (!this.isExtensible(thisObj));
        return true;
    }

    private static boolean testSealedProperties(DynamicObject thisObj) {
        return JSDynamicObject.testProperties((DynamicObject)thisObj, p -> p.isHidden() || (p.getFlags() & 2) != 0);
    }

    private static boolean testFrozenProperties(DynamicObject thisObj) {
        return JSDynamicObject.testProperties((DynamicObject)thisObj, p -> p.isHidden() || (p.getFlags() & 8) != 0 || (p.getFlags() & 4) != 0);
    }

    public final boolean isExtensible(DynamicObject thisObj) {
        return JSShape.isExtensible((Shape)thisObj.getShape());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String toDisplayStringImpl(DynamicObject obj, boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return this.defaultToString(obj);
        }
        return JSRuntime.objectToDisplayString(obj, allowSideEffects, format, depth, this.getClassName(obj));
    }

    @CompilerDirectives.TruffleBoundary
    public final DynamicObject getPrototypeOf(DynamicObject thisObj) {
        return JSObjectUtil.getPrototype((DynamicObject)thisObj);
    }

    public boolean setPrototypeOf(DynamicObject thisObj, DynamicObject newPrototype) {
        return JSNonProxy.setPrototypeStatic(thisObj, newPrototype);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean setPrototypeStatic(DynamicObject thisObj, DynamicObject newPrototype) {
        DynamicObject oldPrototype = JSObject.getPrototype((DynamicObject)thisObj);
        if (oldPrototype == newPrototype) {
            return true;
        }
        if (!JSNonProxy.checkProtoCycle(thisObj, newPrototype)) {
            return false;
        }
        Shape shape = thisObj.getShape();
        if (!JSShape.isExtensible((Shape)shape)) {
            return false;
        }
        if (JSShape.isPrototypeInShape((Shape)shape)) {
            JSObjectUtil.setPrototypeImpl((DynamicObject)thisObj, (DynamicObject)newPrototype);
        } else {
            boolean success = DynamicObjectLibrary.getUncached().putIfPresent(thisObj, (Object)JSObject.HIDDEN_PROTO, (Object)newPrototype);
            assert (success);
        }
        return true;
    }

    public static boolean checkProtoCycle(DynamicObject thisObj, DynamicObject newPrototype) {
        DynamicObject proto = newPrototype;
        while (proto != Null.instance) {
            if (proto == thisObj) {
                return false;
            }
            if (JSProxy.isJSProxy((Object)proto)) {
                return true;
            }
            proto = JSObject.getPrototype((DynamicObject)proto);
        }
        return true;
    }

    protected static void putConstructorSpeciesGetter(JSRealm realm, DynamicObject constructor) {
        JSObjectUtil.putBuiltinAccessorProperty((DynamicObject)constructor, (Object)Symbol.SYMBOL_SPECIES, (DynamicObject)JSNonProxy.createSymbolSpeciesGetterFunction(realm), (DynamicObject)Undefined.instance);
    }

    protected static DynamicObject createSymbolSpeciesGetterFunction(JSRealm realm) {
        return JSFunction.create((JSRealm)realm, (JSFunctionData)JSFunctionData.createCallOnly((JSContext)realm.getContext(), (CallTarget)realm.getContext().getSpeciesGetterFunctionCallTarget(), (int)0, (String)"get [Symbol.species]"));
    }

    public String getBuiltinToStringTag(DynamicObject object) {
        return "Object";
    }

    public boolean usesOrdinaryGetOwnProperty() {
        return true;
    }

    public boolean usesOrdinaryIsExtensible() {
        return true;
    }
}

