/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.tools.utils.json.JSONObject;

public final class Location {
    private final int scriptId;
    private final int line;
    private final int column;

    public Location(int scriptId, int line, int column) {
        this.scriptId = scriptId;
        this.line = line;
        this.column = column;
    }

    public static Location create(JSONObject location) {
        if (location == null) {
            return null;
        }
        String scriptId = location.optString("scriptId");
        if (scriptId == null) {
            return null;
        }
        int line = location.optInt("lineNumber", -1);
        if (line < 0) {
            return null;
        }
        int column = location.optInt("columnNumber", -1);
        try {
            return new Location(Integer.parseInt(scriptId), line + 1, column + 1);
        }
        catch (NumberFormatException nfex) {
            return null;
        }
    }

    public int getScriptId() {
        return this.scriptId;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("scriptId", (Object)Integer.toString(this.scriptId));
        json.put("lineNumber", this.line - 1);
        json.put("columnNumber", this.column - 1);
        return json;
    }
}

