/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.config;

import kd.sdk.kingscript.exception.ScriptException;

public final class LazySetHolder<T> {
    private T lazySetObject;
    private final T defaultObject;
    private final String property;

    public LazySetHolder(String property, T defaultObject) {
        this.property = property;
        this.defaultObject = defaultObject;
    }

    public T get() {
        if (this.lazySetObject == null) {
            String cls = System.getProperty(this.property);
            if (cls == null) {
                return this.defaultObject;
            }
            try {
                this.lazySetObject = Class.forName(cls).newInstance();
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        }
        return this.lazySetObject;
    }
}

